export default class ConfigurationPage {
    constructor() {
        cy.get('#configuration-header').should('be.visible');
    }

    refresh() {
        return new ConfigurationPage();
    }

    getInstance(instanceName) {
        return `.configuration-instance:contains('${instanceName}')`;
    }

    getType(typeName) {
        return `.configuration-type:contains('${typeName}')`;
    }

    openInstance(instanceName) {
        cy.get(`${ this.getInstance(instanceName)} .edit-instance`).click({force: true});
        return new ConfigurationInstancePage();
    }

    addNewInstance(typeName) {
        cy.get(`${ this.getType(typeName)} .new-instance .button`).click({force: true});
        return new ConfigurationInstancePage();
    }

    deleteInstance(instanceName) {
        cy.get(`${ this.getInstance(instanceName)} .delete-instance`).click({force: true});
        return this;
    }

    clearFilter() {
        cy.get('.search-input-filter input').clear({force: true});
        return this;
    }

    searchInstances(criteria) {
        cy.get('.view-container .view').scrollTo('top');
        cy.get('.search-input-filter input').click({force: true}).type(criteria, {force: true});
        return this;
    }

    expectTypeDisplayed(typeName) {
        expect(this.getType(typeName)).toBeDisplayed();
        return this;
    }

    expectInstanceDisplayed(instanceName) {
        cy.get('.view-container .view').scrollTo('bottom');
        cy.get(this.getInstance(instanceName)).should('have.length', 1);
        return this;
    }

    expectInstanceDisplayedOnContent(instanceName) {
        cy.get(this.getInstance(instanceName)).should('have.length', 1);
        return this;
    }

    expectInstanceNotDisplayed(instanceName) {
        cy.get(this.getInstance(instanceName)).should('have.length', 0);
        return this;
    }

    expectNoInstance(instanceName) {
        expect(this.getInstance(instanceName).isPresent()).toBe(false);
        return this;
    }

    expectErrorDisplayed() {
        cy.get('.modal').should('be.visible');
        cy.get('.modal .close').click();
        return this;
    }

    expectSuccessToasterToBeDisplayed(text) {
        cy.get('.toast-success').should('be.visible');
        cy.get('.toast-success').should('contain', text);
        return this;
    }
}

class ConfigurationInstancePage {
    constructor() {
        cy.get('#configuration-instance').should('exist');
    }

    setTextField(fieldName, fieldValue) {
        cy.get(`#${fieldName}`).clear({force: true});
        cy.get(`#${fieldName}`).type(fieldValue, {force: true});
        return this;
    }

    expectFieldToBe(fieldName, fieldValue) {
        cy.get(`#${fieldName}`).should('have.value', fieldValue);
        return this;
    }

    expectFieldToNotContain(fieldName, fieldValue) {
        cy.get(`#${fieldName}`).should('not.have.value', fieldValue);
        return this;
    }

    save() {
        cy.get('button[data-test="submit"]').click();
        cy.get('.toast-success').should('be.visible');
        return this;
    }

    test() {
        cy.get('button[data-test="testButton"]').click();
        return this;
    }

    expectTestButtonToBeDisabled() {
        cy.get('button[data-test="testButton"]').should('be.disabled');
        return this;
    }

    selectFromDropdown(fieldName, element) {
        cy.get(`input[name=${fieldName}]`).clear({force: true});
        cy.get(`input[name=${fieldName}]`).type(element+"{enter}", {force: true, delay: 100});
        return this;
    }

    expectElementToContain(elementCss, value) {
        cy.get(elementCss).first().should('contain', value);
        return this;
    }

    expectSuccessToasterToBeDisplayed(text) {
        cy.get('.toast-success').should('be.visible');
        cy.get('.toast-success').should('contain', text);
        return this;
    }

    expectToBeSaved() {
        cy.get(".last-saved").should('be.visible');
        return this;
    }
}

