import TagEditor from '../components/tag-editor';

export default class ReleaseValueStreamPage {
    constructor() {
        cy.get('#release-value-stream');
    }

    filter({ timeFrame, title, tag }) {
        if (timeFrame) {
            cy.get(`.time-frame button[ng-click*='${timeFrame}']`).click();
        }
        if (title) {
            cy.get('#searchFilter').clear();
            cy.get('#searchFilter').type(title);
            cy.wait(500);
        }
        if (tag) {
            new TagEditor('.tags').addTag(tag);
        }

        return new ReleaseValueStreamPage();
    }

    getRelease(releaseName) {
        return new ReleaseValueStream(`.release:contains('${releaseName}')`);
    }

    expectReleaseNotDisplayed(releaseName) {
        cy.get(`.release:contains('${releaseName}')`).should('not.exist');
        return this;
    }

    expectReleaseDisplayed(releaseName) {
        cy.get(`.release:contains('${releaseName}')`).should('be.visible');
        return this;
    }
}

class ReleaseValueStream {
    constructor(releaseSelector) {
        this.releaseSelector = releaseSelector;
    }

    expectDuration(duration) {
        cy.get(`${this.releaseSelector} .release-details`).invoke('text').should('contain', duration);
        return this;
    }

    getPhase(title) {
        return new PhaseValueStream(`${this.releaseSelector} .phase:contains('${title}')`);
    }
}

class PhaseValueStream {
    constructor(phaseSelector) {
        this.phaseSelector = phaseSelector;
    }

    expectFlagged(number) {
        cy.get(`${this.phaseSelector} .flag-count`).invoke('text').should('contain', number);
        return this;
    }

    expectFailures(number) {
        cy.get(`${this.phaseSelector} .failure-count`).invoke('text').should('contain', number);
        return this;
    }

    expectDelays(number) {
        cy.get(`${this.phaseSelector} .delay-count`).invoke('text').should('contain', number);
        return this;
    }
}
