export default class PersonalAccessTokenPage {
    addToken(tokenText) {
        cy.get('#tokenText').type(tokenText);
        cy.get('.token-btn').click();

        return this;
    }

    copyToken() {
        cy.get('.token-success > .dot-alert-banner').should('be.visible');
        cy.get('.token-success > .dot-alert-banner > .MuiAlert-message').should('be.visible');
        cy.get('.token-success > .dot-alert-banner > .MuiAlert-action').contains('Copy token').should('be.visible');
        cy.get('.token-success > .dot-alert-banner > .MuiAlert-action').contains('Copy token').click();

        return this;
    }

    deleteToken(tokenText) {
        cy.get('.dot-table').should('be.visible');
        cy.get('.dot-table').contains('tr', tokenText).find('td .dot-icon-btn').click();
        cy.contains('button', 'Delete token').click();
        cy.wait(1000);

        return this;
    }

    expectTokenIsAddedToTable(tokenText) {
        cy.get('.dot-table').should('be.visible');
        cy.get('.dot-table').contains('tr', tokenText).should('have.length', 1);

        return this;
    }

    expectTokenIsRemovedFromTable(tokenText) {
        cy.get('.dot-table').should('be.visible');
        cy.get('.dot-table').contains('tr', tokenText).should('have.length', 0);

        return this;
    }
}
