// Wraps the color-picker directive.
export default class ColorPicker {
    // @element: the element where the directive is applied.
    constructor(element) {
        this.element = element; // nothing to do
    }

    expectSelected(index) {
        // using(this.element).expect(element(`.simplecolorpicker div:nth-child(${ index + 1}).selected`).count()).toBe(1);
        cy.get(`${this.element} .simplecolorpicker div:nth-child(${index + 1}).selected`).should('have.length', 1);
    }

    pick(index) {
        cy.get(`${this.element} .toggle-picker`)
            .click({ force: true })
            .then(() => {
                cy.get(`${this.element} .simplecolorpicker div:nth-child(${index + 1})`).click({ force: true });
            });
    }
}
