import { TemplatePropertiesPage } from './properties-page';
import ImportTemplateDialog from '../components/import-template-dialog';

export default class AddTemplateDropdown {
    constructor(path) {
        this.path = path;
    }

    open() {
        cy.doWithRetry(() => cy.get(`${this.path}`).click({ force: true }), '.dot-menu.add-template:visible');
        return this;
    }

    create() {
        this.open();
        cy.get(`.dot-menu.add-template li:contains('Create new template')`).click({ force: true });
        return new TemplatePropertiesPage();
    }

    move() {
        this.open();
        cy.get(`${this.path} .move-template`).click();
        return this;
    }

    import() {
        this.open();
        cy.get(`.dot-menu.add-template li:contains('Import template')`).click();
        return new ImportTemplateDialog();
    }
}
