import ReleaseGroupsTimelinePage from './release-groups-timeline-page';
import Page from './page';

export default class ReleaseGroupsPage {
    constructor() {
        cy.get('#release-groups').should('be.visible');
    }

    setOrderBy(orderBy) {
        cy.get('.order-by-filter .btn:first-child').click();
        cy.get(`.order-by-filter .bootstrap-link:contains('${orderBy}')`).click();
        cy.get('.order-by-filter .btn:first-child').click();
        this.waitForReleaseGroupsLoaded();
        cy.wait(1000);
        return this;
    }

    resetFilter() {
        cy.get(`navigation-sidebar li:contains('Groups')`).click();
        cy.wait(800);
        cy.get('.react-tagsinput').click({ force: true });
        cy.get('.xl-react-link:contains("Clear all")').click();
        cy.wait(1000); // on DB application is slow
        cy.get('.xl-react-components-input-full:visible').first().click();
        cy.get('.react-tagsinput-input').clear().type('Planned');
        cy.get(`[title="Planned"] .checkbox`).click();
        cy.wait(800);
        cy.get(`navigation-sidebar li:contains('Groups')`).click();
        // Page.clickElseWhere(); // sometimes the order by modal do not get closed which fails the test
        this.setOrderBy('Risk');
        return this;
    }

    search(status) {
        // cy.get(`.nav-in-header li:contains('Groups')`).click();
        cy.wait(800);
        cy.get('.react-tagsinput').click({ force: true });
        // cy.get('.xl-react-autocomplete-suggestion-list-container').should('be.visible');
        cy.get('.xl-react-link:contains("Clear all")').click();
        cy.wait(1000); // on DB application is slow
        cy.get('.xl-react-components-input-full:visible').first().click();
        cy.get('.react-tagsinput-input').clear().type(status);
        cy.wait(1000);
        cy.get(`[title="${status}"] .checkbox`).click({ force: true });
        cy.wait(1000);
        // cy.get(`.nav-in-header li:contains('Groups')`).click();
        // Page.clickElseWhere(); // sometimes the order by modal do not get closed which fails the test
        this.setOrderBy('Risk');
        return this;
    }

    openReleaseGroup(title) {
        cy.get(`.fc-list-item-line:contains('${title}') a`).click();
        return new ReleaseGroupsTimelinePage();
    }

    expectReleaseGroupStatus(status) {
        cy.get('.release-status').contains(status);
        return this;
    }

    waitForReleaseGroupsLoaded() {
        cy.get('.fc-list-loaded:visible').should('be.visible');
        return this;
    }

    clickReleaseGroupDelete(title) {
        cy.get(`.fc-list-item-line:contains('${title}') .fc-item-delete`).click({ force: true });
        return this;
    }

    clickReleaseGroupUpdate(title) {
        cy.get(`.fc-list-item-line:contains('${title}') .fc-item-update`).click({ force: true });
        return this;
    }

    clickCreateButton() {
        cy.get('button:contains("New release group")').click();
        cy.get('.modal-header').should('be.visible');
        return this;
    }

    clickModalPrimaryButton() {
        cy.get('.modal-footer .primary').should('be.visible');
        cy.get('.modal-footer .primary').click();
        return this;
    }

    enterReleaseGroupDetails(releaseGroup) {
        cy.get('.modal-body #title').clear();
        cy.get('.modal-body #title').type(releaseGroup.title);
        return this;
    }

    getReleaseGroup(title) {
        return new ReleaseGroupsInList(`.fc-list-item-title-wrapper:contains('${title}')`);
    }

    expectReleaseGroupDisplayed(release) {
        cy.get(`.fc-list-item-title-wrapper:contains('${release}')`, { timeout: 10000 }).should('have.length', 1);
        return this;
    }

    expectReleaseGroupNotDisplayed(release) {
        cy.get(`.fc-list-item-title-wrapper:contains('${release}')`, { timeout: 10000 }).should('have.length', 0);
        return this;
    }
}

class ReleaseGroupsInList {
    constructor(releaseGroupsSelector) {
        this.release = () => using(releaseGroupsSelector);
    }
}
