export default class MainMenuPage {
    expectMenu(title) {
        cy.get(`navigation-sidebar li:contains('${title}')`).should('have.length', 1);
        return this;
    }

    clickMenu(title) {
        cy.get(`navigation-sidebar li:contains('${title}')`).click();
        return this;
    }

    configureSystemMessage() {
        cy.server();
        cy.route('**/settings/system-message*').as('getMessage');
        cy.get('top-toolbar .dot-right-side .dot-badge:nth-child(2) button').click();
        cy.get('#settings > .dot-li:contains("Configure system message")').click();
        cy.wait('@getMessage');
        cy.wait(500);
        cy.get('#enabled').should('be.visible');
        cy.get('button.save.primary').should('be.visible');
        return this;
    }

    logout() {
        cy.get('top-toolbar .avatar-wrapper').click();
        cy.get(".dot-menu li:contains('Log out')").click();
        cy.get('#login').should('be.visible');
        return this;
    }

    expectUserNotVisible() {
        cy.get('top-toolbar .avatar-wrapper .dot-tooltip').should('not.exist');
        return this;
    }

    expectUserVisible() {
        cy.get('top-toolbar .avatar-wrapper .dot-tooltip').should('be.visible');
        return this;
    }
}
