export default class GeneralSettingsPage {
    constructor() {}

    setLoginMessage(message) {
        cy.get('#login-message .edit-icon').invoke('show').click();
        cy.get('#login-message textarea').clear().type(message);
        cy.get('#login-message .ok').click();
        return this;
    }

    clearLoginMessage() {
        cy.get('#login-message .edit-icon').invoke('show').click();
        cy.get('#login-message textarea').clear();
        cy.get('#login-message .ok').click();
        return this;
    }

    setWarningThreshold(value) {
        cy.get('#warningThreshold').clear().type(value);
        return this;
    }

    setErrorThreshold(value) {
        cy.get('#errorThreshold').clear().type(value);
        return this;
    }

    setCriticalPhaseThreshold(value) {
        cy.get('#criticalPhaseThreshold').clear().type(value);
        return this;
    }

    setStatusPollingInterval(value) {
        cy.get('#taskStatusInterval').clear().type(value);
        return this;
    }

    setListPollingInterval(value) {
        cy.get('#taskListInterval').clear().type(value);
        return this;
    }

    setInstanceName(value) {
        cy.get('#header-form-title').clear().type(value);
        return this;
    }

    clearInstanceName() {
        cy.get('#header-form-title').clear();
        return this;
    }

    setHeaderColor(num) {
        cy.get('.toggle-picker').click({ force: true });
        cy.get(`.simplecolorpicker div:nth-child(${num})`).click({ force: true });
        return this;
    }

    expectWarningThreshold(value) {
        cy.get('#warningThreshold').should('have.value', value);
        return this;
    }

    expectErrorThreshold(value) {
        cy.get('#errorThreshold').should('have.value', value);
        return this;
    }

    expectCriticalPhaseThreshold(value) {
        cy.get('#criticalPhaseThreshold').should('have.value', value);
        return this;
    }

    expectStatusPollingInterval(value) {
        cy.get('#taskStatusInterval').should('have.value', value);
        return this;
    }

    expectListPollingInterval(value) {
        cy.get('#taskListInterval').should('have.value', value);
        return this;
    }

    expectArchivingSettingDeleteInterval(value) {
        cy.get('#archivingSettingsAge').should('have.value', String(value));
        return this;
    }

    expectArchivingSettingDeleteIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsAgeUnit"]').find(':selected').should('contain', String(value));
        return this;
    }

    expectTriggerDataPurgingSettingDeleteInterval(value) {
        cy.get('#triggersDataPurgeAge').should('have.value', String(value));
        return this;
    }

    expectTriggerDataPurgingSettingDeleteIntervalUnit(value) {
        cy.get('select[ng-model="triggersDataPurgeSettingsAgeUnit"]').find(':selected').should('contain', String(value));
        return this;
    }

    expectTriggerPurgeDataEnableState(value) {
        cy.get('#triggerDataPurgeSettingsEnabled').should(value ? 'be.checked' : 'not.be.checked');
        return this;
    }

    expectMaxArchiveRetentionInterval(value) {
        cy.get('#archivingSettingsMaxRetentionPeriod').should('have.value', String(value));
        return this;
    }

    expectMaxArchiveRetentionIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsMaxRetentionPeriodUnit"]').find(':selected').should('contain', String(value));
        return this;
    }

    expectInstanceName(value) {
        cy.get('top-toolbar .dot-pill').should('contain', value);
        return this;
    }

    expectHeaderColor(value) {
        cy.get('top-toolbar .dot-app-toolbar').should('have.css', 'border-bottom-color', value);
        return this;
    }

    expectArchivePurgeEnableState(value) {
        cy.get('#archivePurgingEnabled').should(value ? 'be.checked' : 'not.be.checked');
        return this;
    }

    expectConfirmEnableArchivePurgeModal() {
        cy.get('#enablePurgeArchiveModal').should('be.visible');
        return this;
    }

    expectSkipArchiveAllowedState(value) {
        cy.get('#archiveSkipArchiveAllowed').should(value ? 'be.checked' : 'not.be.checked');
        return this;
    }

    setArchivingSettingsDeleteIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsAgeUnit"]').select(value);
        return this;
    }

    setArchivingSettingsDeleteInterval(value) {
        cy.get('#archivingSettingsAge').clear().type(String(value));
        return this;
    }

    setTriggerDataPurgingSettingsDeleteIntervalUnit(value) {
        cy.get('select[ng-model="triggersDataPurgeSettingsAgeUnit"]').select(value);
        return this;
    }

    setTriggerDataPurgingSettingsDeleteInterval(value) {
        cy.get('#triggersDataPurgeAge').clear().type(String(value));
        return this;
    }

    setTriggerDataPurgingSettingsEnabled() {
        cy.get('#triggerDataPurgeSettingsEnabled').check();
        return this;
    }

    clickNotificationTab() {
        cy.get('[data-testid="sideNav-item-1"] .icon-notification-bell').first().click();
        return this;
    }

    expectConfirmationPopUp() {
        cy.get('confirm-leave-modal').should('contain', 'Confirm leave');
        cy.get("confirm-leave-modal button:contains('Leave')").click();
        return this;
    }

    expectNotificationSettingsPage() {
        cy.get('notification-settings-page');
        return this;
    }

    setTriggerPurgeDataEnableState(value) {
        if (value) {
            cy.get('#triggerDataPurgeSettingsEnabled').check();
        } else {
            cy.get('#triggerDataPurgeSettingsEnabled').uncheck();
        }
        return this;
    }

    setMaxArchiveRetentionPeriodIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsMaxRetentionPeriodUnit"]').select(value);
        return this;
    }

    setMaxArchiveRetentionPeriodInterval(value) {
        cy.get('#archivingSettingsMaxRetentionPeriod').clear().type(String(value));
        return this;
    }

    setArchivePurgeEnableState(value) {
        if (value) {
            cy.get('#archivePurgingEnabled').check();
        } else {
            cy.get('#archivePurgingEnabled').uncheck();
        }
        return this;
    }

    setSkipArchiveAllowedState(value) {
        if (value) {
            cy.get('#archiveSkipArchiveAllowed').check();
        } else {
            cy.get('#archiveSkipArchiveAllowed').uncheck();
        }
        return this;
    }

    confirmEnableArchivePurgeModal() {
        cy.get('.save').click();
        return this;
    }

    cancelEnableArchivePurgeModal() {
        cy.get('.modal-footer > .cancel').click();
        return this;
    }

    save() {
        cy.get("action-toolbar button:contains('Save')").click();
        cy.get('.saved-text').should('be.visible');
        cy.get("action-toolbar button:contains('Save')").should('be.disabled');
        return this;
    }

    reset() {
        cy.get("action-toolbar button:contains('Reset')").click();
        cy.get('.saved-text').should('be.visible');
        cy.get("action-toolbar button:contains('Reset')").should('be.disabled');
        return this;
    }

    refresh() {
        cy.reload();
        return this;
    }
}
