export class TopToolbar {
    constructor() {
        cy.get('top-toolbar').should('be.visible');
    }

    openSettingsMenu() {
        cy.get('top-toolbar .dot-right-side .dot-badge:nth-child(2) button').click();
        return this;
    }

    openHelpMenu() {
        cy.get('top-toolbar .dot-right-side .dot-badge:nth-child(1) button').click();
        return this;
    }

    clickOnMenuItem(label) {
        cy.get(`#settings > .dot-li:contains("${label}")`).click();
        return this;
    }

    openModal(label) {
        this.openSettingsMenu();
        return this.clickOnMenuItem(label);
    }

    expectNewPage(pagePath) {
        cy.location('hash').should('eq', `#/${pagePath}`);
        return this;
    }

    expectModalDisplayed(name) {
        cy.get('.modal').should('be.visible');
        cy.get(`.modal .modal-title`).should('contain', name);
        cy.get('.modal .close').click();
        return this;
    }

    expectProductregistrationPage() {
        cy.get('@popup').should('be.called');
        cy.location('pathname').should('contain', `/productregistration`);
        return this;
    }

    expectAboutDisplayed() {
        cy.get('.modal').should('be.visible');
        cy.get(`.modal .modal-header`).should('contain', 'About');
        return cy.get('.modal .close').click();
    }

    expectLinkDisplayed(link) {
        cy.get(`#help > .dot-li:contains("${link}")`).should('be.visible');
        return this;
    }
}
