import { TaskDetails } from './task-details';
import { CodeInlineEditor } from '../../pages/inline-editor';

export class ScriptDetails extends TaskDetails {
    constructor() {
        super();
        this.scriptEditor = new CodeInlineEditor('#resizable-modal .script-content');
    }

    getScript() {
        this.scriptEditor.value();
        return this;
    }

    setScript(value) {
        this.scriptEditor.set(value);
        return this;
    }

    checkIgnoreVariableInterpolation() {
        cy.get('#ignoreScriptVariableInterpolation').check();
        return this;
    }

    uncheckVariableInterpolation() {
        cy.get('#ignoreScriptVariableInterpolation').uncheck();
        return this;
    }

    expectScriptRenderedValueToBe(value) {
        cy.get('.code-inline-textarea').contains(value);
        return this;
    }

    expectScriptEditable() {
        cy.get('div.ace_content:visible').click();
        cy.get('.ace-script-editor-code').should('be.visible');
        cy.get('.ace-script-editor-code').should('not.have.attr', 'disabled');
        cy.get('.ace-script-editor-code').should('not.have.attr', 'readonly');
    }
}
