export default class RestartPhaseModal {
    fromPhase(phase) {
        cy.get('.modal select[data-test="fromPhase"]').select(phase);
        return this;
    }

    fromTask(task) {
        cy.get('.modal select[data-test="fromTask"]').select(task);
        return this;
    }

    expectNoTaskSelectorVisible() {
        cy.get('.modal select[data-test="fromTask"]:visible').should('have.length', 0);
        return this;
    }

    continue() {
        cy.get('.modal .continue').click();
        return this;
    }

    resumeNow() {
        cy.get('.modal .resume-now').click();
        return this;
    }

    resumeLater() {
        cy.get('.modal .resume-later').click();
        return this;
    }
}
