import FolderExplorerPage from '../pages/folder-explorer-page';

export default class TemplateMoveDialog {
    constructor() {
        cy.get(`.folder-template-move-dialog .title:contains('Move template to')`);
    }

    getMoveModalElement() {
        return cy.get(`.folder-template-move-dialog .title:contains('Move template to')`);
    }

    getSubmitMoveElement() {
        return cy.get(`.dialog-buttons button:contains('Move')`);
    }

    getMovePermissionDialogElement() {
        return cy.get(`form[name='permissionsModalForm']`);
    }

    getMergeRadioButtonElement() {
        return cy.get('.merge-action input');
    }

    getReplaceRadioButtonElement() {
        return cy.get('.replace-action input');
    }

    getPermissionNoticeElement() {
        return cy.get('.permission-notice');
    }

    expandFolder(folderName) {
        FolderExplorerPage.expandFolder(folderName);
        return this;
    }

    selectFolder(folderName) {
        FolderExplorerPage.clickOnFolderRow(folderName);
        return this;
    }

    submitMove() {
        const submitMoveBtn = this.getSubmitMoveElement();
        submitMoveBtn.should('be.enabled');
        submitMoveBtn.click();
        return this;
    }

    submitMoveFromPermissionModal() {
        const submitMoveBtn = cy.get(`.modal-footer .button:contains('Move')`);
        submitMoveBtn.should('be.enabled');
        submitMoveBtn.click();
        return this;
    }

    chooseMergePermissionOption() {
        const mergeElem = this.getMergeRadioButtonElement();
        mergeElem.should('be.enabled');
        mergeElem.click();
        return this;
    }

    chooseReplacePermissionOption() {
        const replaceElem = this.getReplaceRadioButtonElement();
        replaceElem.should('be.enabled');
        replaceElem.click();
        return this;
    }

    expectMoveModalToBeVisible(shouldBeVisible = true) {
        const visibilityExpectancy = shouldBeVisible ? 'be.visible' : 'not.exist';
        this.getMoveModalElement().should(visibilityExpectancy);
        return this;
    }

    expectMovePermissionDialogToBeVisible(shouldBeVisible = true) {
        const visibilityExpectancy = shouldBeVisible ? 'be.visible' : 'not.exist';
        this.getMovePermissionDialogElement().should(visibilityExpectancy);
        return this;
    }

    expectMergeActionEnabled(shouldBeEnabled = true) {
        const enabledExpectancy = shouldBeEnabled ? 'be.enabled' : 'be.disabled';
        this.getMergeRadioButtonElement().should(enabledExpectancy);
        return this;
    }

    expectFolderToBeDisabled(folderName, shouldBeDisabled = true) {
        const folderRow = FolderExplorerPage.getFolderRowElement(folderName);
        folderRow.should(`${!shouldBeDisabled ? 'not.' : ''}have.class`, 'disabled');
    }

    expectSubmitMoveButtonToBeEnabled(shouldBeEnabled = true) {
        const enabledExpectancy = shouldBeEnabled ? 'be.enabled' : 'be.disabled';
        this.getSubmitMoveElement().should(enabledExpectancy);
        return this;
    }

    expectPermissionsNoticeToBePresent(shouldBePresent = true) {
        const presentExpectancy = shouldBePresent ? 'be.visible' : 'not.exist';
        this.getPermissionNoticeElement().should(presentExpectancy);
        return this;
    }
}
