export class NotificationSettingsModal {
    constructor(notification) {
        cy.get('h4.modal-title').should('contain', notification);
    }

    getPriorityDropdownElement() {
        return cy.get('.priority-group .xlr-react-select');
    }

    getPriorityDropdownItemElement(priority) {
        return cy.get(`.ant-select-dropdown .ant-select-dropdown-menu-item:contains(${priority})`);
    }

    getSubjectElement() {
        return cy.get(`.modal-body label:contains('Subject') ~ .col-sm-10 input[type=text][name=subject]`);
    }

    getBodyMarkdownSwitcherElement() {
        return cy.get(`.modal-body .body-group .markdown-switcher`);
    }

    getBodyTextareaElement() {
        return this.getBodyMarkdownSwitcherElement().find('textarea');
    }

    getConfirmationLeaveButtonElement() {
        return cy.get(`.leave-confirmation-dialog .modal-footer .button.primary`);
    }

    getModalCancelButtonElement() {
        return cy.get('.modal-footer .button.cancel');
    }

    getModalSaveButtonElement() {
        return cy.get('.modal-footer .button.primary');
    }

    getLeaveConfirmationDialogElement() {
        return cy.get('.leave-confirmation-dialog');
    }

    getNotificationSettingsModalElement() {
        return cy.get('.xl-react-widget-modal-dialog');
    }

    findLeaveButtonElementFromConfirmationDialog() {
        return this.getLeaveConfirmationDialogElement().find("button:contains('Leave')");
    }

    findBodyEditIcon() {
        return this.getBodyMarkdownSwitcherElement().find('button[data-testid="edit-button"]');
    }

    findBodySaveElement() {
        return this.getBodyMarkdownSwitcherElement().find('.actions-wrapper button[data-testid="save-button"]');
    }

    findBodyCloseElement() {
        return this.getBodyMarkdownSwitcherElement().find('.actions-wrapper button[data-testid="cancel-button"]');
    }

    writeIntoBodyTextarea(bodyText) {
        this.findBodyEditIcon().click({ force: true });
        const bodyTextareaElem = this.getBodyTextareaElement();
        bodyTextareaElem.clear();
        bodyTextareaElem.type(bodyText);
        return this;
    }

    saveTextInsideOfBodyTextarea() {
        this.findBodySaveElement().click();
        return this;
    }

    setSubject(subject) {
        const subjectElem = this.getSubjectElement();
        subjectElem.clear();
        subjectElem.type(subject);
        return this;
    }

    setPriority(priority) {
        this.getPriorityDropdownElement().click();
        this.getPriorityDropdownItemElement(priority).click();
        return this;
    }

    setBody(body) {
        this.writeIntoBodyTextarea(body).expectBodyTextareaControlsToExist().saveTextInsideOfBodyTextarea();
        return this;
    }

    hasSubject(subject) {
        this.getSubjectElement().should('have.value', subject);
        return this;
    }

    hasPriority(priority) {
        this.getPriorityDropdownElement().find('.ant-select-selection-selected-value').should('have.text', priority);
        return this;
    }

    hasBody(body) {
        this.getBodyMarkdownSwitcherElement().find('.markdown-wrapper').should('contain', body);
        return this;
    }

    expectNotificationSettingsModalToBeVisible(shouldBeVisible = true) {
        const expectVisibility = shouldBeVisible ? 'be.visible' : 'not.exist';
        this.getNotificationSettingsModalElement().should(expectVisibility);
        return this;
    }

    expectLeaveConfirmationModalToBeVisible(shouldBeVisible = true) {
        this.getLeaveConfirmationDialogElement().should(`${shouldBeVisible ? '' : 'not.'}be.visible`);
        return this;
    }

    expectBodyTextareaControlsToExist(shouldExist = true) {
        const existExpectancy = shouldExist ? 'exist' : 'not.exist';
        this.findBodySaveElement().should(existExpectancy);
        this.findBodyCloseElement().should(existExpectancy);
        return this;
    }

    expectModalSaveButtonToBeEnabled(shouldBeEnabled = true) {
        this.getModalSaveButtonElement().should(`${shouldBeEnabled ? '' : 'not.'}be.enabled`);
        return this;
    }

    expectModalCancelButtonToBeEnabled(shouldBeEnabled = true) {
        this.getModalCancelButtonElement().should(`${shouldBeEnabled ? '' : 'not.'}be.enabled`);
        return this;
    }

    expectModalControlButtonsToBeEnabled(shouldBeEnabled = true) {
        this.expectModalSaveButtonToBeEnabled(shouldBeEnabled).expectModalCancelButtonToBeEnabled(shouldBeEnabled);
        return this;
    }

    confirmLeave() {
        this.findLeaveButtonElementFromConfirmationDialog().click();
        return this;
    }

    save() {
        this.getModalSaveButtonElement().click();
        return this;
    }

    cancel() {
        this.getModalCancelButtonElement().click();
        return this;
    }

    revert() {
        this.getModalCancelButtonElement().click();
        this.getConfirmationLeaveButtonElement().click();
    }
}
