export class TaskDrawer {
    constructor() {
        cy.get('.task-drawer');
    }

    getTaskDrawerHeaderSelector() {
        return cy.get('.task-drawer .task-drawer-header');
    }

    getTaskDrawerSubheaderSelector() {
        return cy.get('.task-drawer .task-subheader');
    }

    close() {
        this.getTaskDrawerHeaderSelector().get('.icon-close').click();
        this.getTaskDrawerHeaderSelector().should('not.exist');
        return this;
    }

    enterFullscreen() {
        this.getTaskDrawerHeaderSelector().get('.icon-fullscreen-enter').click();
        return this;
    }

    exitFullscreen() {
        this.getTaskDrawerHeaderSelector().get('.icon-fullscreen-exit').click();
        return this;
    }

    expectTitleToContain(title) {
        this.getTaskDrawerHeaderSelector().get('.task-title-input').should('contain', title);
        return this;
    }

    expectTypeToContain(type) {
        this.getTaskDrawerHeaderSelector().get('.task-header-icon-wrapper .dot-tooltip').invoke('attr', 'title').should('contain', type);
        return this;
    }
}
