import { NotificationSettings } from './notification-settings';

export default class NotificationSettingsPage extends NotificationSettings {
    constructor() {
        super();
        cy.get('.notification-settings-component').should('be.visible');
    }

    getCancelButtonElement() {
        return cy.get('button:contains("Reset")');
    }

    getSaveButtonElement() {
        return cy.get('button:contains("Save")');
    }

    saveChanges() {
        this.getSaveButtonElement().click();
        return this;
    }

    cancelChanges() {
        this.getCancelButtonElement().click();
        return this;
    }

    typeRoleText(eventId, roleText) {
        cy.get(`.events-permissions-table input#${eventId}`).type(roleText);
        return this;
    }

    addRoleToEvent(roleName, eventId) {
        this.typeRoleText(eventId, roleName);
        this.selectSuggestedRole(roleName);
        return this;
    }

    removeRoleFromEvent(roleName, eventId) {
        const roleElem = this.getRoleElementFromEvent(roleName, eventId);
        roleElem.closest('.role').find('.tag-close').click();
        return this;
    }

    expectCancelButtonToBeEnabled(shouldBeEnabled = true) {
        this.getCancelButtonElement().should(`be.${shouldBeEnabled ? 'enabled' : 'disabled'}`);
        return this;
    }

    expectSaveButtonToBeEnabled(shouldBeEnabled = true) {
        this.getSaveButtonElement().should(`be.${shouldBeEnabled ? 'enabled' : 'disabled'}`);
        return this;
    }

    expectCancelAndSaveButtonsToBeEnabled(shouldBeEnabled = true) {
        const enabledExpectancy = shouldBeEnabled ? 'to.be.enabled' : 'to.not.be.enabled';
        this.getCancelButtonElement().should(enabledExpectancy);
        this.getSaveButtonElement().should(enabledExpectancy);
        return this;
    }

    removeRoleAndAssert(eventName, roleName) {
        this.expectTablesToBeInReadOnlyMode(false)
            .removeRoleTagFromEvent(eventName, roleName)
            .expectRoleTagToBePresentOnEvent(eventName, roleName, false)
            .expectCancelAndSaveButtonsToBeEnabled();
        return this;
    }

    addRoleToEventWithAssertions(eventName, roleName) {
        this.typeRoleTagNameInEventInput(eventName, roleName)
            .expectSuggestedRoleToBeVisible(roleName)
            .selectSuggestedRole(roleName)
            .expectRoleTagToBePresentOnEvent(eventName, roleName)
            .expectCancelAndSaveButtonsToBeEnabled();
        return this;
    }
}
