import ReleasePage from '../../pages/release-page';

export class TaskDrawer {
    constructor() {
        cy.get('.task-drawer');
    }

    close() {
        cy.get('.task-drawer .task-drawer-header .task-drawer-header-controls .icon-close').click();
        cy.get('.task-drawer .task-drawer-header').should('not.exist');
        return this;
    }

    enterFullscreen() {
        cy.get('.task-drawer .task-drawer-header .task-drawer-header-controls .icon-fullscreen-enter').click();
        return this;
    }

    exitFullscreen() {
        cy.get('.task-drawer .task-drawer-header .task-drawer-header-controls .icon-fullscreen-exit').click();
        return this;
    }

    expectTitleToContain(title) {
        cy.get('.task-drawer .task-drawer-header .task-drawer-task-title h3').should('contain', title);
        return this;
    }

    expectTypeToContain(type) {
        cy.get('.task-drawer .task-drawer-header .task-drawer-task-title small').should('contain', type);
        return this;
    }
}
