import FolderTemplatesListPage from './folder-templates-list-page';
import ReleasesListPage from './releases-list-page';
import ReleaseGroupsPage from './release-groups-page';
import { FolderDashboardsPage, FolderPermissionsPage } from './folders';
import FolderVariablesPage from './folder-variables-page';
import ConfigurationPage from './configuration-page';
import VersionControlPage from './folder-version-control-page';
import DeliveryPatternsPage from '../../../../../../../../modules/xlr-release-delivery-module/src/test/javascript/e2e/cypress/support/delivery-pattern-lists-page';
import DeliveriesPage from '../../../../../../../../modules/xlr-release-delivery-module/src/test/javascript/e2e/cypress/support/deliveries-list-page';

export default class FolderDetailsPage {
    open(tab) {
        cy.get(`navigation-sidebar span:contains(${tab})`).click();
    }
    openTemplates() {
        this.open('Templates');
        return new FolderTemplatesListPage();
    }

    openReleases() {
        this.open('Releases');
        return new ReleasesListPage();
    }

    openDeliveryPatterns() {
        this.open('Patterns');
        return new DeliveryPatternsPage();
    }

    openDeliveries() {
        this.open('Deliveries');
        return new DeliveriesPage();
    }

    openGroups() {
        this.open('Groups');
        return new ReleaseGroupsPage();
    }

    openDashboards() {
        this.open('Dashboards');
        return new FolderDashboardsPage();
    }

    openFolderVariables() {
        cy.server();
        cy.route('**/variables*').as('getVariables');
        this.open('Variables');
        cy.wait('@getVariables');
        return new FolderVariablesPage();
    }

    openPermissions() {
        this.open('Teams & permissions');
        return new FolderPermissionsPage();
    }

    getPermissions() {
        return new FolderPermissionsPage();
    }

    openConfigurations() {
        this.open('Connections');
        return new ConfigurationPage();
    }

    openVersionControl() {
        this.open('Version control');
        return new VersionControlPage();
    }

    expectVersionControlEnabled(state) {
        cy.get('navigation-sidebar span').should(state ? 'contain' : 'not.contain', 'Version control');
        return this;
    }
}
