import { XlWidgetAutocomplete } from '../components/xl-components';
import { InlineEditor } from './inline-editor';
import ReleasesListPage from './releases-list-page';
import _ from 'lodash';

export default class TriggersPage {
    constructor() {
        this.listSelector = '#triggers';
    }

    setAllowConcurrentReleasesFromTriggerAndSubmit(checked) {
        let checkbox = element(By.css('#templateForm-allowConcurrentReleasesFromTrigger'));
        if (checkbox.getAttribute('checked') !== checked) {
            checkbox.click();
        }
        element(By.css('#templateForm-save')).click();
        return this;
    }

    newTrigger(type, templateTitle) {
        cy.wait(3000);
        cy.get("action-toolbar button:contains('Add trigger')").click({ force: true });
        cy.get('[data-test-id="triggerType-selector"] input').type(type);
        cy.get(
            `[data-test-id="triggerType-selector"] .xl-react-autocomplete-suggestion-list-container .xl-react-autocomplete-suggestion:contains('${type}')`,
        ).click({ force: true });
        if (templateTitle) cy.get(`.template-select input[value="${templateTitle}"]`).should('be.visible');
        return new TriggerEditPage();
    }

    _expandContextMenu(title) {
        return cy.waitForPopover(`.trigger-row-content:contains('${title}') .context-menu-button`);
    }

    goOnRelatedReleasesOf(triggerName) {
        this._expandContextMenu(triggerName).then(() => {
            cy.get(`.trigger-row-content:contains('${triggerName}') xlr-context-menu a:contains('View releases')`).click({ force: true });
        });
        return new ReleasesListPage();
    }
}

class TriggerEditPage {
    constructor() {
        this.formSelector = "[name='$ctrl.triggerForm']";
    }

    fillFormAndSubmit(fields) {
        this.fillForm(fields);
        return this.submit();
    }

    getAutocomplete(field) {
        return new XlWidgetAutocomplete(`#${field}`);
    }

    fillAutocompleteField(field, value) {
        this.getAutocomplete(field).focus().select(value, true);
        browser.actions().sendKeys(protractor.Key.ENTER).perform();
        return this;
    }

    fillSelectField(field, value) {
        new InlineEditor(`${formSelector} #${field}`).select(value);
        return this;
    }

    fillVariable(variable, value) {
        let editor = new InlineEditor(`div.form-group:contains(${variable})`);
        editor.set(value);
        return this;
    }

    fillForm(fields) {
        if (fields instanceof Object) {
            for (let k in fields) {
                let v = fields[k];
                if (_.isNumber(v)) {
                    cy.get(`${this.formSelector} #${k}`).clear();
                    cy.get(`${this.formSelector} #${k}`).type(`${v}`);
                } else {
                    cy.get(`${this.formSelector} #${k}`).clear();
                    cy.get(`${this.formSelector} #${k}`).type(`${v}`);
                }
            }
        }
        return this;
    }

    submit() {
        cy.get("action-toolbar button:contains('Save')").click({ force: true });
        return new TriggersPage();
    }
}
