export default class TagEditor {
    constructor(path) {
        this.path = path;
    }

    addTag(tagName) {
        cy.get(`${this.path}`).scrollIntoView();
        cy.get(`${this.path} input:visible`).should('have.length', 1);
        cy.get(`${this.path} .tag-input`).type(tagName).type('{enter}');
        return this;
    }

    selectTag(tagName) {
        cy.get(`${this.path} [tag-type="ROLE"] .tag-input`).type(tagName);
        cy.get('.ui-menu-item').click();
        return this;
    }

    removeTag(tagName) {
        cy.get(`${this.path}:contains('${tagName}')`).should('have.length', 1);
        cy.get(`${this.path} li:contains('${tagName}') .tag-close`).click();
        cy.get(`${this.path}:contains('${tagName}')`).should('have.length', 0);
        return this;
    }

    expectTaggedWith(tagName) {
        cy.get(`${this.path} li:contains('${tagName}')`).should('have.length', 1);
        return this;
    }

    expectNotTaggedWith(tagName) {
        cy.get(`${this.path} li:contains('${tagName}')`).should('have.length', 0);
        return this;
    }

    save() {
        cy.get('.continue').click();
        return this;
    }

    expectTaggedWithRole(tagName) {
        cy.get(`${this.path} li.role:contains('${tagName}')`).should('have.length', 1);
        return this;
    }
}
