export default class VersionControlPage {
    saveChanges() {
        cy.get('button:contains("Save")').click();
        return this;
    }

    cancelChanges() {
        cy.get('button:contains("Cancel")').click();
        return this;
    }

    createNewGitConfig(title, url) {
        cy.get('.no-configuration .button').click({ force: true });
        cy.get('#configuration').should('be.visible');
        cy.get('#title').type(title);
        cy.get('#url').type(url);
        cy.get(`div[name=authenticationMethod]`).click();
        cy.get(`select[name=authenticationMethod]`).select('None');
        cy.get('button:contains("Save")').click();
        return this;
    }

    saveNewVersion(version, description) {
        cy.get('#save-version').click();
        //cy.get('.confirmation-content').should('be.visible');
        cy.get('.drawer-footer-form button:contains("Save")').should('be.disabled');
        cy.get('input[name=name]').type(version);
        cy.get('.drawer-footer-form button:contains("Save")').should('be.enabled');
        cy.get('textarea').type(description);
        cy.get('.drawer-footer-form button:contains("Save")').click();
        return this;
    }

    configureVersionControl() {
        cy.get('.button').click();
        return this;
    }

    openConfiguration() {
        cy.get('button:contains("Configure")').click();
        return this;
    }

    fetchChanges() {
        cy.get('button:contains("Fetch")').click();
        return this;
    }

    expectVersionCountToBe(length) {
        cy.get('.version-item').should('have.length', length);
        return this;
    }

    expectVersionIsApplied(version) {
        const selector = `.version-item .name:contains(${version}) .label`;
        cy.get(selector).should('contain', 'Applied');
        return this;
    }

    selectVersion(version) {
        const selector = `.version-item .name:contains(${version})`;
        cy.get(selector).click();
        return this;
    }

    applyVersion(version) {
        this.selectVersion(version);
        cy.get('#apply-version').click();
        cy.get('button:contains("OK")').click();
        return this;
    }

    previewVersion(version) {
        this.selectVersion(version);
        cy.get('.preview .button').click();
        cy.get('.version-content').should('be.visible');
        return this;
    }

    previewShouldContain(testString) {
        cy.get('.ace_editor .ace_scroller .ace_content .ace_text-layer').should('contain', testString);
        return this;
    }

    previewShouldNotContain(testString) {
        cy.get('.ace_editor .ace_scroller .ace_content .ace_text-layer').should('not.contain', testString);
        return this;
    }

    expectConfigurationValues(branch, repoPath) {
        cy.get('.no-configuration .button').should('be.visible');
        cy.get('input[name="branch"]').should('have.value', branch);
        cy.get('input[name="scmPath"]').should('have.value', repoPath);
        cy.get('.export-row').should('have.length', 8);
        return this;
    }

    expectCanEditVersions(hasPermission) {
        cy.get('button:contains("Fetch")').should('be.visible');
        cy.get('.preview .button').should('be.visible');

        if (hasPermission) {
            cy.get('#save-version').should('be.visible');
            cy.get('button:contains("Configure")').should('be.visible');
        } else {
            cy.get('#save-version').should('not.exist');
            cy.get('button:contains("Configure")').should('not.exist');
        }
        return this;
    }

    expectCanSaveVersions(hasPermission) {
        if (hasPermission) {
            cy.get('#save-version').should('be.visible');
        } else {
            cy.get('#save-version').should('not.exist');
        }
        return this;
    }

    expectCanApplyVersions(version, hasPermission) {
        this.selectVersion(version);
        if (hasPermission) {
            cy.get('#apply-version').should('be.visible');
        } else {
            cy.get('#apply-version').should('not.exist');
        }
        return this;
    }

    selectGitConnection(connectionName) {
        cy.get('.fv-connection-form .xl-react-widget-autocomplete input').clear();
        cy.get('.fv-connection-form .xl-react-widget-autocomplete input').click({ force: true }).type(connectionName);
        cy.get(
            `.fv-connection-form .xl-react-widget-autocomplete .xl-react-autocomplete-suggestion-list-container .xl-react-autocomplete-suggestion:contains('${connectionName}')`,
        ).click({ force: true });
        cy.get('.with-search input[type=text]').should('have.value', connectionName);
        return this;
    }

    setProperty(name, value) {
        cy.get(`input[name=${name}]`).clear();
        cy.get(`input[name=${name}]`).type(value);
        return this;
    }

    expectConfigurationSplashVisible() {
        cy.get('.notice-title').should('be.visible');
        cy.get('.button').should('be.visible');
        return this;
    }

    expectVersionHistoryVisible() {
        cy.get('#folder-history').should('be.visible');
        return this;
    }

    expectConfigurationVisible() {
        cy.get('#versioning-configuration').should('be.visible');
        return this;
    }

    expectSaveEnabled(saveEnabled) {
        cy.get('button:contains("Cancel")').should('be.enabled');
        cy.get('button:contains("Save")').should(saveEnabled ? 'be.enabled' : 'be.disabled');
        return this;
    }

    expectGitConnectionSelected(connectionName) {
        if (connectionName === '') {
            cy.get('.with-search input[type=text]').should('be.empty');
        } else {
            cy.get('.with-search input[type=text]').should('have.value', connectionName);
        }
        return this;
    }
}
