export default class ReleaseGanttPage {
    constructor() {
        cy.get('#gantt').should('be.visible');
    }

    getLeftPanel() {
        return new GanttLeftPanel();
    }

    expectReleaseDisplayed(releaseTitle) {
        cy.get('#gantt').contains(releaseTitle);
        cy.get('#gantt .gantt_container').should('have.length', 1);
        return this.expectItemDisplayed(releaseTitle);
    }

    expectItemDisplayed(itemTitle) {
        return cy.get('#gantt .gantt_container .gantt_task_content').contains(itemTitle);
    }

    // expectItemNotDisplayed(itemTitle) {
    //     expect(element('#gantt .gantt_container .gantt_task_content').text()).not().toContain(itemTitle);
    //     return this;
    //
    //
    // expectPhaseDisplayed(phaseTitle) {
    //     return this.expectItemDisplayed(phaseTitle);
    // }
    //
    // expectTaskDisplayed(taskTitle) {
    //     return this.expectItemDisplayed(taskTitle);
    // }
    //
    // expectTaskNotDisplayed(taskTitle) {
    //     return this.expectItemNotDisplayed(taskTitle);
    // }
    //
    // expectSameWidth(title1, title2) {
    //     dimensions().expectSameWidth(`.gantt_task_line:contains('${title1}')`, `.gantt_task_line:contains('${title2}')`);
    //     return this;
    // }
    //
    // expectDifferentWidth(title1, title2) {
    //     dimensions().expectDifferentWidth(`.gantt_task_line:contains('${title1}')`, `.gantt_task_line:contains('${title2}')`);
    //     return this;
    // }
    //
    // expectElementWithClasses(title, ...classes) {
    //     expect(element(`.gantt_task_line:contains('${title}').${classes.join('.')}`).count()).toBe(1);
    //     return this;
    // }

    open(title) {
        cy.get(`.gantt_cell:contains('${title}') .gantt_open`).should('be.visible').click({ force: true });
        return this;
    }

    // expectDisplayedInScale(text) {
    //     expect(element('#gantt .gantt_scale_line').text()).toContain(text);
    //     return this;
    // }
    //
    // expectDateDisplayedInScale(format, date) {
    //     dates().expectContainingDate('#gantt .gantt_scale_line', format, date);
    //     return this;
    // }
    //
    // selectBiggerZoom() {
    //     element("#gantt #gantt-zooms-container .btn:contains('+')").click();
    //     return this;
    // }
    //
    // selectLowerZoom() {
    //     element("#gantt #gantt-zooms-container .btn:contains('-')").click();
    //     return this;
    // }
    //
    // dragToDayIndex(title, index) {
    //     this.expectElementVisible(title);
    //     appElement(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).dragTo(`.gantt_task_row .gantt_task_cell:eq(${index})`);
    //     return this;
    // }
    //
    // refresh() {
    //     Page.softReload();
    //     return this;
    // }
    //
    // expectLinksToBeDisplayed(number) {
    //     expect(element('.gantt_task_link').count()).toBe(number);
    //     return this;
    // }
    //
    // expectElementVisible(title) {
    //     expect(element(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).count()).toBe(1);
    //     return this;
    // }
    //
    // expectLeftHandleVisibility(title, visible) {
    //     this.expectElementVisible(title);
    //
    //     let noHandleCount = visible ? 0 : 1;
    //     expect(element(`#gantt .gantt_container .gantt_task_line:contains('${title}').gantt-no-left-handle`).count()).toBe(noHandleCount);
    //     return this;
    // }
    //
    // expectRightHandleVisibility(title, visible) {
    //     this.expectElementVisible(title);
    //
    //     let noHandleCount = visible ? 0 : 1;
    //     expect(element(`#gantt .gantt_container .gantt_task_line:contains('${title}').gantt-no-right-handle`).count()).toBe(noHandleCount);
    //     return this;
    // }
    //
    // openTaskDetails(title, buildResult) {
    //     element(`.gantt_task_content:contains('${title}')`).query(function (element, done) {
    //         element.dblclick();
    //         return done();
    //     });
    //     return buildResult();
    // }
    //
    // openManualTaskDetails(title) {
    //     return this.openTaskDetails(title, () => new TaskDetails());
    // }
    //
    // openPhaseDetails(title) {
    //     element(`.gantt_task_content:contains('${title}')`).query(function (element, done) {
    //         element.dblclick();
    //         return done();
    //     });
    //     return new PhaseDetails;
    // }

    toggleDatesColumns() {
        cy.get('#toggleIsDatesColumnsShown').click();
        return this;
    }
}

class GanttLeftPanel {
    constructor() {
        this.leftPanel = () => using('#gantt .gantt_grid_data');
    }

    // expectNameDisplayed(name) {
    //     expect(this.leftPanel().element('.gantt_tree_content').text()).toContain(name);
    //     return this;
    // }

    expectStartDateDisplayed(name, date) {
        cy.get(`.gantt_row:contains('${name}') .gantt_cell:nth-child(2) span.date input`).then(($input) => {
            const startDate = new Date($input.val());
            cy.wrap(startDate).as('startDate').invoke('getDay').should('eq', date.getDay());
            cy.get('@startDate').invoke('getMonth').should('eq', date.getMonth());
            cy.get('@startDate').invoke('getFullYear').should('eq', date.getFullYear());
        });
        return this;
    }

    // expectEndDateDisplayed(name, date) {
    //     dates().expectValueContainingDate(`.gantt_row:contains('${name}') .gantt_cell:eq(2) input`, "shortDate", date);
    //     return this;
    // }
}
