import Page from '../page';
import TagEditor from '../../components/tag-editor';

export default class ReleasePermissionsPage {
    constructor() {
        cy.get('#permissions-table').should('have.length', 1);
    }

    save() {
        cy.get("action-toolbar button:contains('Save')").click();
        return this;
    }

    reset() {
        cy.get("action-toolbar button:contains('Reset')").click();
        return this;
    }

    grantMembersPermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.addTag(`${member}`);
        }
        return this;
    }

    revokeMembersPermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.removeTag(`${member}`);
        }
        return this;
    }

    expectMembersToHavePermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.expectTaggedWith(`${member}`);
        }
        return this;
    }

    expectMembersNotToHavePermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.expectNotTaggedWith(`${member}`);
        }
        return this;
    }

    expectResetEnabled(enabled = true) {
        if (enabled) {
            cy.get("action-toolbar button:contains('Reset'):disabled").should('have.length', 0);
        } else {
            cy.get("action-toolbar button:contains('Reset'):disabled").should('have.length', 1);
        }
        return this;
    }

    static expectInheritMessagePresent(folder) {
        cy.get(`.content-under-header p`).contains(`Permissions and Teams are inherited from the folder`).should('be.visible');
        cy.get(`.content-under-header p span a`).contains(`${folder}`);
        return this;
    }

    expectSaveEnabled(enabled = true) {
        if (enabled) {
            cy.get("action-toolbar button:contains('Save'):disabled").should('have.length', 0);
        } else {
            cy.get("action-toolbar button:contains('Save'):disabled").should('have.length', 1);
        }
        return this;
    }

    refresh() {
        Page.softReload();
        return this;
    }
}
