import FolderDetailsPage from '../pages/folder-details-page';
import ReleasesListPage from './releases-list-page';

export default class FolderExplorerPage {
    static getBackToAllFoldersElement() {
        return cy.get('.return-btn-wrapper');
    }

    static getSidebarTitleButton() {
        return cy.get('.folder-header .header-item.title-btn-wrapper .folder-title');
    }

    static getFolderPopoverToggleButtonElement() {
        return cy.get('navigation-sidebar .popover-wrapper');
    }

    static getFolderOptionsElement(folderName) {
        return cy.get(`.folder-row-wrapper:contains(${folderName}) .folder-options-wrapper`);
    }

    static getAddFolderButtonElement() {
        return cy.get('button.btn-add-folder');
    }

    static getFolderPopoverElement() {
        return cy.get('.ant-popover-inner-content .folder-tree-wrapper');
    }

    static getFolderRowElement(folderName) {
        return cy.get(`.folder-row-wrapper:contains(${folderName})`);
    }

    static getTabElement(tabName) {
        return cy.get(`navigation-sidebar span:contains(${tabName})`);
    }

    static findExpandIconOnFolderRowElement(folderRowElem) {
        return folderRowElem.find('.arrow-right-icon');
    }

    static goToExplorer() {
        cy.visit('#/folders');
        return this;
    }

    static openFolder(folderName) {
        cy.get(`.folder-row-wrapper:contains(${folderName})`).scrollIntoView().should('be.visible');
        // We are clicking/opening folder by clicking anywhere inside of wrapped list item
        // which now has a button role (instead of a span with folder name, as was previously)
        cy.get(`.folder-row-wrapper:contains(${folderName}) li[role=button]`).click();
        return new FolderDetailsPage();
    }

    static expandFolder(folderName) {
        const folderRowElem = this.getFolderRowElement(folderName);
        folderRowElem.scrollIntoView().should('be.visible');
        const expandIconElem = this.findExpandIconOnFolderRowElement(folderRowElem);
        expandIconElem.should('be.visible');
        expandIconElem.click();
        return this;
    }

    static clickOnFolderRow(folderName) {
        const folderRowElem = this.getFolderRowElement(folderName);
        folderRowElem.scrollIntoView().should('be.visible');
        folderRowElem.click();
        return this;
    }

    static clickOnFolderTitleButton() {
        const folderTitleButton = this.getSidebarTitleButton();
        folderTitleButton.scrollIntoView().should('be.visible');
        folderTitleButton.click();
        return this;
    }

    static openFolderPopover() {
        const openPopoverBtnElem = this.getFolderPopoverToggleButtonElement();
        openPopoverBtnElem.scrollIntoView().should('be.visible');
        openPopoverBtnElem.click();
        this.getFolderPopoverElement().should('be.visible');
        return this;
    }

    static clickOnFolderRowAction(folderName, actionLabel) {
        cy.get(`.folder-row-wrapper:contains(${folderName}) .folder-options-wrapper`).invoke('show').find(`.flatten-links a:contains(${actionLabel})`).click();
        return this;
    }

    static clickOnTab(tabName) {
        this.getTabElement(tabName).click();
        return this;
    }

    static clickOnReleaseTab() {
        this.clickOnTab('Release');
        return new ReleasesListPage();
    }

    static expandEast() {
        Browser.waitForDisplayed('.toggler.toggler-collapse');
        cy.get('.toggler.toggler-collapse').click();
        return this;
    }

    static openCreateNewFolderModalAndInput(folderName) {
        this.getAddFolderButtonElement().click();
        cy.get('.xl-react-modal-content input').type(folderName);
        return this;
    }

    static createNewFolder(folderId) {
        cy.wait(1500);
        this.openCreateNewFolderModalAndInput(folderId);
        cy.get('.xl-react-modal-content .button.primary').click();
        cy.wait(1500);
        return this;
    }

    static expectContainsFolderRow(folderName, condition) {
        cy.get(`.folder-row-wrapper:contains(${folderName})`).should('have.length', condition ? 1 : 0);
        return this;
    }

    static searchFolder(folderName) {
        cy.get('.folder-list .search-input').type(folderName);
        return this;
    }

    static collapseAllFolders() {
        cy.get('button.btn-collapse-all').click();
        return this;
    }

    static expandAllFolders() {
        cy.get('button.btn-expand-all').click();
        return this;
    }

    static deleteFolder() {
        cy.get('.dropdown-menu li:contains("Delete")').click();
        cy.get('.modal-dialog .button.primary').click();
        return this;
    }

    static expectFolderRowContainsCorrectActionItems() {
        const items = ['Add folder', 'Rename folder', 'Delete folder'];
        for (const item of items) {
            cy.get(`.flatten-links a:contains(${item})`).should('be.visible');
        }
        return this;
    }

    static showFolderOptions(folderName) {
        cy.get(`.folder-row-wrapper:contains(${folderName}) .folder-options-wrapper`).invoke('show').click();
    }

    static toggleFolder(folderName) {
        cy.get(`.folder-row-wrapper:contains(${folderName}) .rstm-toggle-icon`).click();
        return this;
    }

    static createNewFolderFromRowAction(folderName, subFolderName) {
        this.clickOnFolderRowAction(folderName, 'Add folder');
        cy.get('.xl-react-modal-content input').type(subFolderName);
        cy.get('.xl-react-modal-content .button.primary').click();
        return this;
    }

    static renameFolderFromRowAction(folderToRename, folderName) {
        this.clickOnFolderRowAction(folderToRename, 'Rename folder');
        cy.get(`.folder-row-wrapper input`).clear().type(folderName).type('{enter}');
        return this;
    }

    static deleteFolderFromRowAction(folderTitle) {
        this.clickOnFolderRowAction(folderTitle, 'Delete folder');
        cy.get('.xl-react-modal-content button.primary').click();
        return this;
    }

    static navigateBackToAllFolders() {
        this.getBackToAllFoldersElement().click();
        return this;
    }

    static expectAddFolderButtonEnabled(enabled = true) {
        cy.get('button.btn-add-folder').should(`${enabled ? 'not.' : ''}have.attr`, 'disabled');
        return this;
    }

    static expectAllFoldersCollapsed() {
        cy.get('.folder-tree .arrow-down-icon').should('not.exist');
        return this;
    }

    static expectAllFoldersExpanded() {
        cy.get('.folder-tree .arrow-right-icon').should('not.exist');
        return this;
    }

    static expectFolderRenameErrorDialogShown() {
        cy.get(`.xl-react-modal-content .confirmation-content:contains(Folder name is already in use. Please choose another name.)`).should('be.visible');
    }

    static expectValidationErrorShown(text) {
        cy.get(`.xl-react-modal-content .error:contains(${text})`).should('be.visible');
    }

    static expectBackToAllFoldersButtonShown() {
        this.getBackToAllFoldersElement().should('be.visible');
        return this;
    }

    static expectFolderNameToBeVisible() {
        this.getSidebarTitleButton().should('be.visible');
        return this;
    }

    static expectPopoverToggleButtonToBeVisible() {
        this.getFolderPopoverToggleButtonElement().should('be.visible');
        return this;
    }

    static expectFolderPopoverToExist(shouldExist = true) {
        const existExpectancy = shouldExist ? 'exist' : 'not.exist';
        this.getFolderPopoverElement().should(existExpectancy);
        return this;
    }

    static expectFolderPopoverToBeVisible(shouldBeVisible = true) {
        const visibilityExpectancy = shouldBeVisible ? 'be.visible' : 'not.be.visible';
        this.getFolderPopoverElement().should(visibilityExpectancy);
        return this;
    }

    static expectFolderOptionsToExist(folderName, shouldExist = true) {
        const existExpectancy = shouldExist ? 'exist' : 'not.exist';
        this.getFolderOptionsElement(folderName).should(existExpectancy);
    }

    static expectAddFolderButtonToExist(shouldExist = true) {
        const existExpectancy = shouldExist ? 'exist' : 'not.exist';
        this.getAddFolderButtonElement().should(existExpectancy);
    }
}
