export class DipMapStringString {
    constructor(path) {
        this.path = path;
        cy.get(this.path).scrollIntoView();
        cy.get(this.path).should('have.length', 1);
        this.mapStringString = cy.get(this.path);
        this.keyClass = '.input-key';
        this.valueClass = '.input-value';
    }

    setKey(key) {
        this.clearKey();
        this.enter(`${this.path} ${this.keyClass}`, key);
        return this;
    }

    setValue(value) {
        this.clearValue();
        this.enter(`${this.path} ${this.valueClass}`, value);
        return this;
    }

    focus(selector) {
        cy.get(`${this.path} ${selector}`).click();
        return this;
    }

    enter(elementClass, text) {
        cy.get(`${elementClass}`).type(text, { force: true });
        return this;
    }

    expectInput(key, value) {
        cy.get(`${this.keyClass}`)
            .invoke('text')
            .then((text) => {
                expect(text).to.equal(key);
            });
        cy.get(`${this.valueClass}`)
            .invoke('text')
            .then((text) => {
                expect(text).to.equal(value);
            });
        return this;
    }

    removeFirstItem() {
        cy.get('.table-scrollable-container td div.xl-btn-close:first').scrollIntoView();
        cy.get(`${this.path} .table-scrollable-container td div.xl-btn-close:first`).click();
        return this;
    }

    removeItem(text) {
        cy.get(`${this.path} .table-scrollable-container tr:contains('${text}') .xl-btn-close`).click();
        return this;
    }

    clearInput() {
        this.clearKey();
        return this.clearValue();
    }

    clearKey() {
        cy.get(`${this.keyClass}`).clear({ force: true });
        return this;
    }

    clearValue() {
        cy.get(`${this.valueClass}`).clear({ force: true });
        return this;
    }

    add(key, value) {
        this.setKey(key);
        this.setValue(value);
        cy.get(`${this.path} .xl-map-string-string-div-buttons .xl-button`).click({ force: true });
        return this;
    }

    expectAddIsDisabled(isDisabled = 'true', description = 'Add button should be disabled') {
        cy.get(".xl-map-string-string-div-buttons:contains('Add') .xl-button").then((el) => {
            if (!!isDisabled) {
                expect(el).to.be.disabled;
            } else {
                expect(el).to.be.enabled;
            }
        });
        return this;
    }

    expectAddIsEnabled() {
        this.expectAddIsDisabled('false', 'Add button should be enabled');
        return this;
    }

    getItems() {
        return cy.get(`${this.path} .table-scrollable-container .table-scrollable table tbody tr`);
    }

    shouldHaveSize(expectedSize) {
        this.getItems().should('have.length', expectedSize);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(Object.keys(expectedItems).length);
        this.getItems().each(($item) => {
            cy.wrap($item)
                .find('.xl-map-key')
                .then(($key) => {
                    const key = $key.get(0).innerText;
                    cy.wrap($item)
                        .find('.xl-map-value')
                        .then(($value) => expect($value.get(0).innerText).to.equal(expectedItems[key]));
                });
        });
        return this;
    }
}
