import Modal from '../components/modal';
import ReleasePage from './release-page';
import ColorPicker from '../components/color-picker';
import ReleasesListPage from './releases-list-page';
import DateTimePicker from '../components/date-time-picker';

export default class CalendarNewPage {
    constructor() {
        cy.get('.timeline').should('be.visible');
    }

    openContextMenu(date) {
        this.getDayHeaderCell(date)
            .closest('li')
            .find('.tl-context-menu-layover:visible')
            .find('.tl-context-menu')
            .then((elements) => {
                elements[0].style.display = 'block';
                return elements;
            })
            .find('.options-icon')
            .click({force: true});
        return this;
    }

    openSetBlackoutDialog(date) {
        this.openContextMenu(date);
        cy.get('.context-menu-popover:visible a:visible:contains("Set blackout period")')
            .click({force: true});
        return this;
    }

    openSetDateLabelDialog(date, edit = false) {
        this.openContextMenu(date);
        cy.get(`.context-menu-popover:visible a:visible:contains("${edit ? 'Edit' : 'Set'} label")`)
            .click({force: true});
        return this;
    }

    setBlackoutDate(startOrEnd, date) {
        // set date
        const day = date.format('D');
        const findDateDiv = () => Cypress.$('div.react-datepicker__day:visible').filter((index, element) => !/react-datepicker__day--outside-month/.test(element.getAttribute('class')) && element.textContent.trim() === String(day));
        cy.get(`label:visible:contains("${startOrEnd} date")`)
            .closest('div.form-group:visible')
            .find('div.react-datepicker__input-container:visible input')
            .click({force: true})
            .doWithRetry(
                () => cy.wait(500),
                () => expect(Cypress.$('div.react-datepicker__current-month:visible').text().trim().toLowerCase()).to.equal(date.format('MMMM YYYY').toLowerCase()),
                () => cy.get('button.react-datepicker__navigation.react-datepicker__navigation--next:visible').click({force: true}).wait(500)
            )
            .get('div.react-datepicker__day:visible')
            .then((elements) => elements.filter((index, element) => !/react-datepicker__day--outside-month/.test(element.getAttribute('class')) && element.textContent.trim() === String(day))).then((e) => {
                if (e[0] && !/react-datepicker__day--selected/.test(e[0].getAttribute('class'))) {
                    e[0].click();
                }
            });

        // time
        cy.get(`label:visible:contains("${startOrEnd} date")`)
            .contains(`${startOrEnd} date`)
            .closest('div.form-group:visible')
            .find('div.time-input:visible input:visible')
            .click({force: true})
            // hours
            .doWithRetry(() => {},
                () => expect(Cypress.$('div.popover-content:visible div.xl-react-widget-time-content:visible .hour-time:visible').text().trim()).to.equal(String(date.format('h'))),
                () => cy.get('button.plus-hour:visible').click({force: true}).wait(10),
                100)
            // minutes
            .doWithRetry(() => {},
                () => expect(Cypress.$('div.popover-content:visible div.xl-react-widget-time-content:visible .minute-time:visible').text().trim()).to.equal(String(date.format('mm'))),
                () => cy.get('button.plus-minute:visible').click({force: true}).wait(10),
                100)
            // AM/PM
            .doWithRetry(() => {},
                () => expect(Cypress.$('div.popover-content:visible div.xl-react-widget-time-content:visible div.am-pm:visible button:visible').text().trim()).to.equal(date.format('A')),
                () => cy.get('div.popover-content:visible div.xl-react-widget-time-content:visible div.am-pm:visible button:visible').click({force: true}).wait(10),
                100);

        return this;
    }

    setBlackoutLabel(label) {
        cy.get('input[placeholder="Label"]:visible')
            .type(label);
        return this;
    }

    saveBlackout() {
        cy.server();
        cy.route('**/calendar/blackouts*').as('saveBlackout');
        cy.get('.button.primary:visible').click({force: true});
        cy.wait('@saveBlackout');
    }

    saveDateLabel() {
        cy.server();
        cy.route('**/calendar/specialDays*').as('saveDateLabel');
        cy.get('.button.primary:visible').click({force: true});
        cy.wait('@saveDateLabel');
    }

    createBlackout(label, start, end) {
        this.openSetBlackoutDialog(start)
            .setBlackoutDate('Start', start)
            .setBlackoutDate('End', end)
            .setBlackoutLabel(label)
            .saveBlackout();
    }

    setLabelText(text) {
        cy.get('input[placeholder="Label"]:visible').clear()
            .type(text);
        return this;
    }

    setLabelColor(colorHexString) {
        cy.get('.tl-label-modal div.swatch div').click();
        cy.get('.color-picker-popover input[spellcheck="false"]').clear()
            .type(/#*([\d|\w]+)/g.exec(colorHexString.toLowerCase())[1]);
        return this;
    }

    addDateLabel(date, label, color) {
        this.openSetDateLabelDialog(date)
            .setLabelText(label)
            .setLabelColor(color)
            .saveDateLabel();
    }

    getDayHeaderCell(date) {
        const day = date.date();
        const fn = () => {
            const filtered = Cypress.$('.timeline:visible .tl-dates:visible .tl-header-day:visible').filter((index, element) => {
                const m = /^\s*(\d+)/.exec(element.textContent);
                return m && m[1] && m[1] === ('0' + day).substr(-2)
            });
            return filtered;
        };
        return cy.doWithRetry( // no other way to make our .then retriable
            () => {}, // do nothing
            () => expect(fn().length).to.equal(1)) // wait until the date we ask for appears
            .then(() => fn()); // return the cell
    }

    expectDateHeadingToHaveBlackoutLabel(date, hasBlackout = true) {
        this.getDayHeaderCell(date)
            .closest('li')
            .should(`${hasBlackout ? '' : 'not.'}have.class`, 'tl-has-blackout');
        return this;
    }

    expectDateHeadingToHaveDateLabel(date, hasDateLabel = true) {
        this.getDayHeaderCell(date)
            .closest('li')
            .should(`${hasDateLabel ? '' : 'not.'}have.class`, 'tl-has-label');
        return this;
    }

    expectDateLabelToHaveColor(date, rgbColor) {
        this.getDayHeaderCell(date)
            .closest('li').find(`div[style="background: rgb(${rgbColor[0]}, ${rgbColor[1]}, ${rgbColor[2]});"]`)
            .should('exist');
        return this;
    }

    expectDateLabelToHaveTooltipText(date, tooltip) {
        this.getDayHeaderCell(date).closest('li').find(`div.tl-label`).trigger('mouseover', 'top');
        cy.get('div[role="tooltip"] div.popover-content').should('contain', tooltip);
        return this;
    }

    openBlackoutPopup(date) {
        this.getDayHeaderCell(date)
            .closest('li')
            .find('div.tl-blackout:visible')
            .click({force: true});
        cy.get('div.ant-popover-inner-content:visible').should('exist');
        return this;
    }

    navigateToNextBlackout() {
        cy.get('div.blackout-popover-navigation:visible i.xl-icon.chevron-right-icon:visible').click({force: true});
        return this;
    }

    deleteCurrentBlackout() {
        cy.get('div.blackout-popover-footer:visible button.button:visible:contains("Delete")').click({force: true});
        return this;
    }

    editBlackout(label, start, end) {
        cy.get('div.blackout-popover-footer:visible button.button:visible:contains("Edit")').click({force: true});
        this.setBlackoutDate('Start', start);
        this.setBlackoutDate('End', end);
        this.setBlackoutLabel(label);
        this.saveBlackout();
        return this;
    }

    editDateLabel(date, label, color) {
        this.openSetDateLabelDialog(date, true)
            .setLabelText(label)
            .setLabelColor(color)
            .saveDateLabel();
    }

}
