export default class FeaturesSettingsPage {
    constructor() {
        cy.get('#feature-setting').should('be.visible');
    }

    getFeatureControl(feature, control) {
        return cy.get(`fieldset:contains(${feature}) .form-group:contains(${control}) input`)
    }

    enableFeature(feature, control = 'Enabled') {
        this.getFeatureControl(feature, control).check();
        return this;
    }

    disableFeature(feature, control = 'Enabled') {
        this.getFeatureControl(feature, control).uncheck();
        return this;
    }

    setFeaturePropertyInput(feature, property, value) {
        this.getFeatureControl(feature, property).clear().type(value);
        return this;
    }

    expectFeatureToBeEnabled(feature, state = true, control = 'Enabled') {
        this.getFeatureControl(feature, control).should(state ? 'be.checked' : 'not.be.checked');
        return this;
    }

    expectFeaturePropertyToBe(feature, property, value) {
        this.getFeatureControl(feature, property).should('have.value', value);
        return this;
    }

    expectToBeSaved() {
        cy.get(".last-saved").should('be.visible');
        return this;
    }

    expectSaveToBeEnabled(state) {
        cy.get('.submit').should(state ? 'not.be.disabled' : 'be.disabled');
        return this;
    }

    expectResetToBeEnabled(state) {
        cy.get('.reset').should(state ? 'not.be.disabled' : 'be.disabled');
        return this;
    }

    save() {
        cy.get('.submit').click();
        return this;
    }

    saveIfNeeded() {
        cy.get('.submit')
        .invoke('attr', 'disabled')
        .then(disabled => {
            if (!disabled) {
                cy.get('.submit').click();
            }
        })
        return this;
    }

    reset() {
        cy.get('.reset').click();
        return this;
    }

}
