export default class ConfirmLeave {

    constructor() {
        this.root = 'confirm-leave-modal';
    }

    expectVisible() {
        cy.get(`${this.root} .modal-content`).should('be.visible');
        return this;
    }

    close() {
        cy.get(`${this.root} button.cancel`).click();
        cy.get(`${this.root} .modal-content`).should('not.exist');
        return this;
    }

    leave() {
        cy.get(`${this.root} button.primary`).click();
        cy.get(`${this.root} .modal-content`).should('not.exist');
        return this;
    }

}
