export class DipSetString {
    constructor(path) {
        this.path = path;
        cy.get(this.path).should('have.length', 1);
        this.inputClass = '.dip-input input';
        // this.setString = cy.get(this.path);
    }

    setInput(text) {
        this.clearInput();
        cy.get(`${this.path} ${this.inputClass}`).type(text);
        return this;
    }

    add() {
        cy.get(`${this.path} .xl-btn-add`).click({force: true});
        return this;
    }

    focus(selector) {
        cy.get(`${this.path} ${selector}`).click();
        return this;
    }

    enter(text) {
        cy.get(`${this.path} .dip-input input`).type(text, {force: true});
        return this;
    }

    clearInput() {
        cy.get(`${this.path} ${this.inputClass}`).clear();
        return this;
    }

    removeFirstItem() {
        cy.get(`${this.path} li .xl-btn-close:visible:first`).click();
        // this.setString.all(By.$("li .xl-btn-close:visible")).first().click();
        return this;
    }

    expectAddIsDisabled() {
        cy.get(`${this.path} .xl-btn-add:disabled`).should('be.visible');
        // expect(this.setString.element(By.$(".xl-btn-add:disabled"))).toBeDisplayed();
        return this;
    }

    expectAddIsEnabled() {
        cy.get(`${this.path} .xl-btn-add`).should('be.visible');
        // expect(this.setString.element(By.$(".xl-btn-add"))).toBeDisplayed();
        return this;
    }

    expectInputInvisible() {
        expect(this.setString).to.not.exist;
        return this;
    }

    getItems() {
        return cy.get(`${this.path} .xl-list-row`);
    }

    shouldHaveSize(expectedSize) {
        this.getItems().should('have.length', expectedSize);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(expectedItems.length);
        this.getItems().each(($item, i) => {
            cy.wrap($item).should('contain', expectedItems[i]);
        });
        return this;
    }
}
