import 'cypress-file-upload';

export default class ImportTemplateDialog {
    uploadFile(templateName) {
        cy.fixture(templateName, 'binary')
            .then(Cypress.Blob.binaryStringToBlob)
            .then(fileContent => {
            cy.get("#importTemplateModal input[type='file']").attachFile(
                {fileContent, fileName: templateName, mimeType: 'application/zip'}
            );
        });
        cy.get('#importTemplateModal button.import').click();
        return this;
    }

    close() {
        cy.get('.modal button.close').click();
        return this;
    }

    uploadAndCheckExpectations(templateName, afterUploadExpectation) {
        return this.expectFileSelectorDisplayed()
            .expectImportButtonDisabled()
            .uploadFile(templateName)[afterUploadExpectation]()
            .close();
    }

    expectFileSelectorDisplayed() {
        cy.get("#importTemplateModal input[type='file']").should('be.visible');
        return this;
    }

    expectImportButtonDisabled() {
        cy.get("#importTemplateModal .import:disabled").should('be.visible');
        return this;
    }

    expectFileUploaded() {
        cy.get("#importTemplateModal .results:contains('Template successfully imported'):visible");
        return this;
    }

    expectFileUploadedWithWarning() {
        cy.get(".modal-body:contains('Teams in this template have been removed. They will be inherited from the folder'):visible");
        return this;
    }

    expectFileUploadRejected() {
        cy.get("#importTemplateModal .error:contains('Task use is not granted to you for types'):visible");
        return this;
    }
}
