import {TextareaInlineEditor} from '../inline-editor';

export default class DashboardPage {

    setProperty(name, value) {
        cy.get(`input[name=${name}]`).clear();
        cy.get(`input[name=${name}]`).type(value);
        return this;
    }

    clickConfigureDashboard() {
        return this.clickButtonWithName('Configure dashboard');
    }

    clickEditDashboard(){
        return this.clickSecButtonWithName('Edit properties');
    }

    expectSaveButtonDisabled() {
        cy.get('.button.save').should('be.disabled');
        return this;
    }

    clickConfigureTile(title) {
        cy.get(`[data-title='${title}']`).trigger('mouseover');
        cy.get(`[data-title='${title}'] [data-test="configure-tile-btn"]`).click();
        return this;
    }

    setTileContent(content) {
        let editor = new TextareaInlineEditor('#markdown-tile-dropdown');
        editor.set(content);
        return this;
    }

    expectSaveButtonEnabled() {
        cy.get('.button.save').should('be.enabled');
        return this;
    }

    searchTileWithTitle(title) {
        cy.get('#tile-filter').type(title);
        return this;
    }

    selectTileWithTitle(title) {
        cy.get(`.tile-card-title:contains('${title}')`)
            .trigger('mouseover')
            .next('.primary')
            .click();
        return this;
    }

    expectTileCardVisible(name, isPresent = true) {
        cy.get(`.tile-card-title:contains('${name}')`).should('have.length', isPresent ? 1 : 0);
        return this;
    }

    clickBackToViewMode() {
        return this.clickSecButtonWithName('Back to view mode')
            .buttonShouldNotBeVisible('Back to view mode');
    }

    clickSecButtonWithName(name) {
        cy.get(`.button:contains(${name})`).click();
        return this;
    }

    clickButtonWithName(name) {
        cy.get(`.primary:contains(${name})`).click();
        return this;
    }

    buttonShouldNotBeVisible(name) {
        cy.get(`.button:contains(${name})`).should('not.exist');
        return this;
    }

    save() {
        cy.get('button.save').click();
        return this;
    }

    expectTileContent(content) {
        cy.get('.markdown-tile-view').should('contain', content);
    }

    expectValue(field, value) {
        cy.get(`#dashboardForm #${field}`).should('have.value', value);
        return this;
    }

    expectTileVisible(name, isPresent = true) {
        cy.get(`.tile-title:contains('${name}')`).should('have.length', isPresent ? 1 : 0);
        return this;
    }
}
