import DashboardPage from './dashboard-page';

export default class FolderDashboardsPage {
    addDashboard(template) {
        template = template || "Blank template";
        cy.get('.folder-dashboard-header [data-test="add-dashboard"]').click();
        cy.get(`.tile-card:contains('${template}') .primary`).click();
        return new DashboardPage();
    }

    openNthDashboard(n) {
        cy.get('.fd-item a.raised-link').should('have.length.above', 0);
        cy.get('.fd-item a.raised-link').eq(n).click();
        return new DashboardPage();
    }

    filterList(filter) {
        cy.get('.filters input[type="search"]').clear().type(filter);
        return this;
    }

    expectDashboardsCountToBe(count) {
        cy.get('.folder-dashboard-list .fd-item').should('have.length', count);
        return this;
    }

    expectNthDashboardToHaveTitle(n, title) {
        cy.get('.folder-dashboard-list .fd-item').should('have.length.above', 0);
        cy.get('.folder-dashboard-list .fd-item').eq(n)
            .contains(title);
        return this;
    }
}
