
export default class VersionControlPage {

    saveChanges() {
        cy.get('.primary').click();
        return this;
    }

    cancelChanges() {
        cy.get('.cancel').click();
        return this;
    }

    createNewGitConfig(title, url) {
        cy.get('.no-configuration .button').click({force: true});
        cy.get('#configuration').should('be.visible');
        cy.get('#title').type(title);
        cy.get('#url').type(url);
        cy.get(`div[name=authenticationMethod]`).click();
        cy.get(`select[name=authenticationMethod]`).select('None');
        cy.get('button[data-test="submit"]').click();
        return this;
    }
    
    saveNewVersion(version, description) {
        cy.get('#save-version').should('be.visible').click();7
        cy.get('.confirmation-content').should('be.visible');
        cy.get('.primary').should('be.disabled');
        cy.get('input[name=name]').type(version);
        cy.get('.primary').should('be.enabled');
        cy.get('textarea').type(description);
        cy.get('.confirmation-dialog div .primary').click();
        return this;
    }

    configureVersionControl() {
        cy.get('.button').click();
        return this;
    }

    openConfiguration() {
        cy.get('#configure-btn').click();
        return this;
    }

    fetchChanges() {
        cy.get('.bwp-button .button').click();
        return this;
    }

    expectVersionCountToBe(length) {
        cy.get('.version-item').should('have.length', length);
        return this;
    }

    expectVersionIsApplied(version) {
        const selector = `.version-item .name:contains(${version}) .label`;
        cy.get(selector).should('contain', "Applied");
        return this;
    }

    selectVersion(version) {
        const selector = `.version-item .name:contains(${version})`;
        cy.get(selector).click();
        return this;
    }

    applyVersion(version) {
        this.selectVersion(version);
        cy.get('#apply-version').click();
        cy.get('.xl-react-modal-content').should('be.visible');
        cy.get('.confirmation-dialog div .primary').click();
        return this;
    }
    
    previewVersion(version) {
        this.selectVersion(version);
        cy.get('.preview .button').click();
        cy.get('.version-content').should('be.visible');
        return this;
    }

    previewShouldContain(testString) {
        cy.get('.ace_editor .ace_scroller .ace_content .ace_text-layer').should('contain', testString);
        return this;
    }

    previewShouldNotContain(testString) {
        cy.get('.ace_editor .ace_scroller .ace_content .ace_text-layer').should('not.contain', testString);
        return this;
    }

    expectConfigurationValues(branch, repoPath, tag) {
        cy.get('.no-configuration .button').should('be.visible');
        cy.get('input[name="branch"]').should('have.value', branch); 
        cy.get('input[name="scmPath"]').should('have.value', repoPath); 
        cy.get('input[name="tagPrefix"]').should('have.value', tag); 
        cy.get('.export-row').should('have.length', 8);
        return this;
    }
    
    expectCanEditVersions(hasPermission) {
        cy.get('.bwp-button .button').should('be.visible');
        cy.get('.preview .button').should('be.visible');
        
        if (hasPermission) {
            cy.get('#save-version').should('be.visible');
            cy.get('#configure-btn').should('be.visible');
        } else {
            cy.get('#save-version').should('not.exist');
            cy.get('#configure-btn').should('not.exist');
        }
        return this;
    }

    selectGitConnection(connectionName) {
        cy.get('.fv-connection-form .xl-react-widget-autocomplete input').clear();
        cy.get('.fv-connection-form .xl-react-widget-autocomplete input').click({force: true}).type(connectionName);
        cy.get(`.fv-connection-form .xl-react-widget-autocomplete .xl-react-autocomplete-suggestion-list-container .xl-react-autocomplete-suggestion:contains('${connectionName}')`).click({force: true});
        cy.get('.with-search input[type=text]').should('have.value', connectionName);
        return this;
    }        
    
    setProperty(name, value) {
        cy.get(`input[name=${name}]`).clear();
        cy.get(`input[name=${name}]`).type(value);
        return this;
    }

    expectConfigurationSplashVisible() {
        cy.get('.notice-title').should('be.visible');
        cy.get('.button').should('be.visible');
        return this;
    }

    expectVersionHistoryVisible() {
        cy.get('#folder-history').should('be.visible');
        return this;
    }

    expectConfigurationVisible() {
        cy.get('#versioning-configuration').should('be.visible');
        return this;
    }

    expectSaveEnabled(saveEnabled) {
        cy.get('.cancel').should('be.enabled');
        cy.get('.primary').should(saveEnabled ? 'be.enabled' : 'be.disabled');
        return this;
    }

    expectGitConnectionSelected(connectionName) {
        if (connectionName == "") {
            cy.get('.with-search input[type=text]').should('be.empty');
        } else {
            cy.get('.with-search input[type=text]').should('have.value', connectionName);
        }        
        return this;
    }
}
