import {TaskDetails} from "../components/task-details";

export default class TasksGridPage {
    constructor() {
        cy.get('.task-grid-view-container').should('be.visible');
    }

    expectTaskCountDisplayed(count) {
        cy.get('task-grid .task').not(":contains('Welcome')").should('have.length', count);
        return this;
    }

    assignedToMyTeam() {
        cy.get('.btn-group-filter button:nth(1)').click();
        return this;
    }

    expectTaskDetailsDisplayed(taskId, taskStatus, taskTitle, assignedTo, release, phase, startDate) {
        cy.get(`[data-test-id=${taskId}] .header`).should('contain', taskStatus);
        cy.get(`[data-test-id=${taskId}] .title`).should('contain', taskTitle);
        cy.get(`[data-test-id=${taskId}] .assignee span`).should('contain', assignedTo);
        cy.get(`[data-test-id=${taskId}] [data-test=release]`).should('contain', release);
        cy.get(`[data-test-id=${taskId}] [data-test=phase]`).should('contain', phase);
        if (startDate) {
            cy.get(`[data-test-id=${taskId}] [data-test=started]`).should('contain', startDate);
        } else {
            cy.get(`[data-test-id=${taskId}] .caption`).should('not.contain', 'Started');
        }
        return this;
    }

    openManualTaskDetails(taskId) {
        return this.openTaskDetails(taskId, () => new TaskDetails());
    }

    openTaskDetails(taskId, buildResult) {
        cy.doWithRetry(
            () => cy.get(`[data-test-id=${taskId}] .header`).click({force: true}),
            '#resizable-modal:visible');
        return buildResult();
    }

    openContextMenu(taskId) {
        cy.get(`[data-test-id=${taskId}] .options-icon`).click();
        return this;
    }

    hideContextMenu(taskId) {
        cy.get(`[data-test-id=${taskId}] .options-icon`).click();
        return this;
    }

    triggerContextMenuAction(action) {
        cy.get(`#context-menu-container li a:contains(${action})`).click();
        if (action === 'Complete') {
            cy.get("#modal textarea[mentio]:visible").should('be.visible');
            cy.get("#modal textarea[mentio]:visible").type('complete');
            cy.get("#modal button.primary:contains('Complete')").click();
            return this;
        }
        return this;
    }

    expectContextMenuHas(enabled, disabled = []) {
        cy.get('#context-menu-container li:not(.disabled) a').should('have.length', enabled.length);
        enabled.forEach(e => {
            cy.get('#context-menu-container li:not(.disabled) a').should('contain', e);
        });
        cy.get('#context-menu-container li.disabled a').should('have.length', disabled.length);
        disabled.forEach(e => {
            cy.get('#context-menu-container li.disabled a').should('contain', e);
        });
        return this;
    }

    waitForTaskNotDisplayed(taskId) {
        cy.get(`[data-test-id=${taskId}]`)
            .should('not.be.visible', {timeout: 20});
        return this;
    }
}