export default class FeaturesSettingsPage {
    constructor() {
        cy.get('#feature-setting').should('be.visible');
    }

    toggleEnabledProperty() {
        cy.get('#testFeatureEnabled').click();
        return this;
    }

    expectEnabledPropertyToBe(state) {
        cy.get(`input[type='checkbox']#testFeatureEnabled`).should(state ? 'be.checked' : 'not.be.checked');
        return this;
    }

    expectToBeSaved() {
        cy.get(".last-saved").should('be.visible');
        return this;
    }

    expectSaveToBeEnabled(state) {
        cy.get('.submit').should(state ? 'not.be.disabled' : 'be.disabled');
        return this;
    }

    expectResetToBeEnabled(state) {
        cy.get('.reset').should(state ? 'not.be.disabled' : 'be.disabled');
        return this;
    }

    save() {
        cy.get('.submit').click();
        return this;
    }

    reset() {
        cy.get('.reset').click();
        return this;
    }

}
