export default class DateFilters {
    static expectDateFilters(filters,format) {
        if (filters.from) {
            cy.compareToLocalDate(filters.from,'.date-filter.from-date .date-picker-holder input',format);
        } else {
            cy.get('.date-filter.from-date .date-picker-holder').should('contain', 'Set date');
        }

        if (filters.to) {
            cy.compareToLocalDate(filters.to,'.date-filter.to-date .date-picker-holder input',format);
        } else {
            cy.get('.date-filter.to-date .date-picker-holder').should('contain', 'Set date');
        }
    }

    static expectGanttDateFilters(name,filters,format) {
        if (filters.from) {
            cy.compareToLocalDate(filters.from,`.gantt_row:contains('${name}') .gantt_cell:eq(1) input`,format);
        } else {
            cy.compareToLocalDate(filters.to,`.gantt_row:contains('${name}') .gantt_cell:eq(2) input`,format);
        }
    }

    static expectGanttLeftPanelDateFilters(filters,format) {
        cy.containLocalDate(filters.from,'#gantt .gantt_scale_line',format);
    }
}
