export default class UsersPage {
    constructor() {
        cy.get('#users').should('have.length',1);
        // waitFor('#users');
    }

    addUser() {
        cy.get("span.new-user").click();
        // element("span.new-user").click();
        return new UserModal;
    }

    updateUser(username) {
        cy.get(`tr:contains('${username}')`).click();
        return new UserModal;
    }

    deleteUser(username) {
        cy.get(`tr:contains('${username}') .delete-user`).should('be.visible');
        cy.get(`tr:contains('${username}') .delete-user`).click();
        cy.get('.modal .continue').should('be.visible');
        cy.get('.modal .continue').click();
        return this;
    }

    shouldBeVisible() {
        cy.get("#users").should('be.visible');
        return this;
    }

    expectUsers(...users) {
        for (const user of users) {
            cy.get(`tr:contains('${user.name}')`).should('have.length.above',0);
            // expect(element(`tr:contains('${user.name}')`).count()).toBe(1);
            const type = user.external ? "External" : "Internal";
            cy.get(`tr:contains('${user.name}') td.type:contains('${type}')`).should('have.length.above',0);
            // expect(element(`tr:contains('${user.name}') td.type:contains('${type}')`).count()).toBe(1);
            if (user.email !== null) {
                cy.get(`tr:contains('${user.name}') td.email:contains('${user.email}')`).should('have.length.above',0);
                // expect(element(`tr:contains('${user.name}') td.email:contains('${user.email}')`).count()).toBe(1);
            }
            if (user.fullName !== undefined) {
                cy.get(`tr:contains('${user.name}') td.full-name:contains('${user.fullName}')`).should('have.length.above',0);
                // expect(element(`tr:contains('${user.name}') td.full-name:contains('${user.fullName}')`).count()).toBe(1);
            }

            cy.get(`tr:contains('${user.name}') td.delete-user`).should('have.length.above',0);
            // expect(element(`tr:contains('${user.name}') td.delete-user`).count()).toBe(1);
        }
        return this;
    }

    expectNoUser(username) {
        cy.get(`tr:contains('${username}')`).should('have.length',0);
        // expect(element(`tr:contains('${username}')`).count()).toBe(0);
        return this;
    }

    sortByColumn(columnClass) {
        cy.get('thead th.' + columnClass).click();
        return this;
    }

    assertCellInRow(rowSelector, cellClass, predicate, value) {
        cy.get('tbody ' + rowSelector + ' td.' + cellClass).should(predicate, value);
        return this;
    }

    filter(username) {
        cy.get('.actions input').type(username);
        // input('userFilter').enter(username);
        return this;
    }

    reload() {
        cy.reload();
        // Page.softReload();
        return this;
    }
}

class UserModal {
    constructor() {
        cy.get(".modal").should("be.visible");
    }

    setName(name) {
        cy.get("#username").clear().type(name);
        return this;
    }

    expectNameEditDisabled() {
        cy.get(".modal input[ng-model='users.editedUser.username']:disabled").should('have.length',1);
        return this;
    }

    setPassword(password) {
        cy.get('input[data-test="password-input"]').clear().type(password);
        cy.get("#passwordConfirmation").type(password);
        return this;
    }

    setPreviousPassword(password) {
        cy.get("#previousPassword").clear().type(password);
        return this;
    }

    setEmail(email) {
        cy.get("#email").should('be.visible');
        cy.get("#email").clear().type(email);
        return this;
    }

    clearEmail() {
        cy.get("#email").should('be.visible');
        cy.get("#email").clear();
        return this;
    }

    clearFullName() {
        cy.get("#full-name").should('be.visible');
        cy.get("#full-name").clear();
        return this;
    }

    setFullName(fullName) {
        cy.get("#full-name").clear().type(fullName);
        return this;
    }

    save() {
        cy.get('.modal .button.save').click();
        cy.wait(1500);
        return this;
    }

    cancel() {
        cy.get('.modal .button.cancel').click();
        cy.get('.modal .button.cancel').should('not.exist');
        return this;
    }

    expectOpen() {
        cy.get(".modal:visible").should('have.length',1);
        // expect(element(".modal:visible").count()).toBe(1);
        return this;
    }


    reload() {
        cy.reload();
        // Page.softReload();
        return this;
    }

    expectErrorMessage(errorMessage) {
        cy.get(`span.error:contains('${errorMessage}')`).should('have.length',1);
        // expect(element(`span.error:contains('${errorMessage}')`).count()).toBe(1);
        return this;
    }

    expectNoEmail() {
        cy.get("#email").should('have.value','');
        // expect(using(".modal").input('users.editedUser.email').val()).toBe('');
        return this;
    }

    expectNoFullName() {
        cy.get("#full-name").should('have.value','');
        // expect(using(".modal").input('users.editedUser.fullName').val()).toBe('');
        return this;
    }

    expectSaveButtonDisabled() {
        cy.get('.modal .button.save').should('be.disabled');
        return this;
    }

    expectSaveButtonEnabled() {
        cy.get('.modal .button.save').should('be.enabled');
        return this;
    }

    expectPasswordValidationComponentStatus(status) {
        const passwordValidationComponent = cy.get('.password-input-component');
        switch (status) {
            case 'empty':
                passwordValidationComponent.contains(/Type in password\.\s*Password requirements\s*\d\/\d/);
                passwordValidationComponent.find('.xl-icon').should('have.length', 0);
                break;
            case 'invalid':
                passwordValidationComponent.contains(/This password does not meet the password requirements\s*\d\/\d/);
                passwordValidationComponent.find('.xl-icon.icon-s.warning-icon').should('have.length', 1);
                break;
            default:
                passwordValidationComponent.contains('This password meets the password requirements.');
                passwordValidationComponent.find('.xl-icon').should('have.length', 0);
                break;
        }
        switch (status) {
            case 'empty':
            case 'invalid':
                cy.get('.password-hint-container').trigger('mousemove');
                cy.get('.validation-message')
                    .should('be.visible')
                    .find('.xl-icon.circle-minus-icon').its('length').should('be.gte', 1);
                cy.get('.password-hint-container').trigger('mouseout');
                break;
            default:
                break;
        }
        return this;
    }
}
