export class DipListString {
    constructor(path) {
        this.path = path;
        cy.get(this.path).scrollIntoView().should('have.length', 1);
        this.addBtn = cy.get(`${this.path} .xl-btn-add`);
        this.inputField = cy.get(`${this.path} .dip-input input`);
    }

    add() {
        cy.get(`${this.path} .xl-btn-add`).click({force: true});
        return this;
    }

    focus() {
        cy.get(`${this.path} .dip-input input`).click();
        return this;
    }

    enter(text) {
        cy.get(`${this.path} .dip-input input`).type(text, {force: true});
        return this;
    }

    removeFirstItem() {
        cy.get(`${this.path} .xl-list-row .xl-btn-close`).first().click({force: true});
        return this;
    }

    getItems() {
        return cy.get(`${this.path} .xl-list-row`);
    }

    shouldHaveSize(expectedSize) {
        this.getItems().should('have.length', expectedSize);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(expectedItems.length);
        this.getItems().each(($item, i) => {
            cy.wrap($item).should('contain', expectedItems[i]);
        });
        return this;
    }

    expectAddIsNotVisible() {
        this.addBtn.should('not.be.visible');
        return this;
    }

    expectInputIsNotVisible() {
        this.inputField.should('not.be.visible');
        return this;
    }
}
