export default class GeneralSettingsPage {
    constructor() {

    }

    setLoginMessage(message) {
        cy.get('#login-message .edit-icon').invoke('show').click();
        cy.get('#login-message textarea').clear().type(message);
        cy.get('#login-message .ok').click();
        return this;
    }

    clearLoginMessage() {
        cy.get('#login-message .edit-icon').invoke('show').click();
        cy.get('#login-message textarea').clear();
        cy.get('#login-message .ok').click();
        return this;
    }

    setWarningThreshold(value) {
        cy.get('#warningThreshold').clear().type(value);
        return this;
    }

    setErrorThreshold(value) {
        cy.get("#errorThreshold").clear().type(value);
        return this;
    }

    setCriticalPhaseThreshold(value) {
        cy.get("#criticalPhaseThreshold").clear().type(value);
        return this;
    }

    setStatusPollingInterval(value) {
        cy.get('#taskStatusInterval').clear().type(value);
        return this;
    }

    setListPollingInterval(value) {
        cy.get('#taskListInterval').clear().type(value);
        return this;
    }

    setInstanceName(value) {
        cy.get('#header-form-title').clear().type(value);
        return this;
    }

    clearInstanceName() {
        cy.get('#header-form-title').clear();
        return this;
    }

    setHeaderColor(num) {
        cy.get('.toggle-picker').click({force: true});
        cy.get(`.simplecolorpicker div:nth-child(${num})`).click({force: true});
        return this;
    }

    expectWarningThreshold(value) {
        cy.get('#warningThreshold').should('have.value', value);
        return this;
    }

    expectErrorThreshold(value) {
        cy.get('#errorThreshold').should('have.value', value);
        return this;
    }

    expectCriticalPhaseThreshold(value) {
        cy.get('#criticalPhaseThreshold').should('have.value', value);
        return this;
    }

    expectStatusPollingInterval(value) {
        cy.get('#taskStatusInterval').should('have.value', value);
        return this;
    }

    expectListPollingInterval(value) {
        cy.get('#taskListInterval').should('have.value', value);
        return this;
    }

    expectArchivingSettingDeleteInterval(value) {
        cy.get('#archivingSettingsAge').should('have.value', String(value));
        return this;
    }

    expectArchivingSettingDeleteIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsAgeUnit"]').find(':selected').should('contain', String(value));
        return this;
    }

    expectTriggerDataPurgingSettingDeleteInterval(value) {
        cy.get('#triggersDataPurgeAge').should('have.value', String(value));
        return this;
    }

    expectTriggerDataPurgingSettingDeleteIntervalUnit(value) {
        cy.get('select[ng-model="triggersDataPurgeSettingsAgeUnit"]').find(':selected').should('contain', String(value));
        return this;
    }

    expectInstanceName(value) {
        cy.get('.header-environment-name').should('contain', value);
        return this;
    }

    expectHeaderColor(value) {
        cy.get('.main-header-wrapper').should('have.css', 'border-bottom-color', value);
        return this;
    }

    setArchivingSettingsDeleteIntervalUnit(value) {
        cy.get('select[ng-model="archivingSettingsAgeUnit"]').select(value);
        return this;
    }

    setArchivingSettingsDeleteInterval(value) {
        cy.get("#archivingSettingsAge").clear().type(String(value));
        return this;
    }

    setTriggerDataPurgingSettingsDeleteIntervalUnit(value) {
        cy.get('select[ng-model="triggersDataPurgeSettingsAgeUnit"]').select(value);
        return this;
    }

    setTriggerDataPurgingSettingsDeleteInterval(value) {
        cy.get("#triggersDataPurgeAge").clear().type(String(value));
        return this;
    }


    save() {
        cy.get('.submit').click();
        return this;
    }

    refresh() {
        cy.reload();
        return this;
    }
}
