import Page from './page';
import TagEditor from '../components/tag-editor';

export default class ReleasePermissionsPage {
    constructor() {
        cy.get('#permissions-table').should('have.length', 1);
    }

    save() {
        cy.get('.save').click();
        return this;
    }

    reset() {
        cy.get('.reset').click();
        return this;
    }

    grantMembersPermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.addTag(`${member}`);
        }
        return this;
    }

    revokeMembersPermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.removeTag(`${member}`);
        }
        return this;
    }

    expectMembersToHavePermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.expectTaggedWith(`${member}`);
        }
        return this;
    }

    expectMembersNotToHavePermission(permission, ...members) {
        const permissionEditor = new TagEditor(`tr:contains('${permission}')`);
        for (let member of members) {
            permissionEditor.expectNotTaggedWith(`${member}`);
        }
        return this;
    }

    expectResetEnabled(enabled = true) {
        if (enabled) {
            cy.get('.reset:disabled').should('have.length', 0);
        } else {
            cy.get('.reset:disabled').should('have.length', 1);
        }
        return this;
    }

    expectSaveEnabled(enabled = true) {
        if (enabled) {
            cy.get('.save:disabled').should('have.length', 0);
        } else {
            cy.get('.save:disabled').should('have.length', 1);
        }
        return this;
    }

    refresh() {
        Page.softReload();
        return this;
    }
}
