import TagEditor from '../components/tag-editor';

export class PropertiesPage {
    setScheduledStartDate(date) {
        let dateTimePicker = new DateTimePicker(".scheduled-start-date .date-editor");
        dateTimePicker.setDateTime(date);
        return this;
    }

    setDueDate(date) {
        let dateTimePicker = new DateTimePicker(".due-date .date-editor");
        dateTimePicker.setDateTime(date);
        return this;
    }

    setDuration(duration) {
        let dateTimePicker = new DurationPicker("[duration-editor]");
        dateTimePicker.setDuration(duration);
        return this;
    }

    expectScheduledStartDateToBe(dateFomat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker(".scheduled-start-date .date-editor");
        dateTimePicker.expectDateToBe(dateFomat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectDueDateToBe(dateFomat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker(".due-date .date-editor");
        dateTimePicker.expectDateToBe(dateFomat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectDurationToBe(duration) {
        let durationPicker = new DurationPicker("[duration-editor]");
        durationPicker.expectDurationToBe(duration);
        return this;
    }

    setScriptUsername(username) {
        new InlineEditor(".script-username").set(username);
        return this;
    }

    setScriptUserPassword(password) {
        new InlineEditor(".script-userpassword").set(password);
        return this;
    }

    save() {
        cy.get('.continue').click();
        return this;
    }
}


export class ReleasePropertiesPage extends PropertiesPage {
    constructor() {
        super();
        Browser.waitFor('#release-properties');
    }

    selectTemplate(template) {
        element(By.id('release-form-template')).element(By.cssContainingText('option', template)).click();
        return this;
    }

    setName(name) {
        cy.get('release-form-title').type(name);
        return this;
    }

    setDescription(description) {
        new TextareaInlineEditor(".release-description").set(description);
        return this;
    }

    expectTemplateTitleToBe(title) {
        expect($('a[data-test="created-from-template"]').getText()).toBe(title);
        return this;
    }

    expectRiskProfileTitleToBe(title) {
        expect($('a[data-test="release-risk-profile"]').getText()).toBe(title);
        return this;
    }

    expectTemplateURLToBe(url) {
        expect($('a[data-test="created-from-template"]').getAttribute("ng-href")).toBe(url);
        return this;
    }

    expectParentReleaseTitleToBe(title) {
        expect(element(By.css('.started-from-release')).getText()).toBe(title);
        return this;
    }

    expectParentReleaseURLToBe(url) {
        expect(element(By.css('.started-from-release')).getAttribute("ng-href")).toBe(url);
        return this;
    }

    expectDescriptionToContain(description) {
        expect(element(By.css(".release-description.markdown")).getText()).toContain(description);
        return this;
    }

    scrollToVariables() {
        Browser.scrollTo(By.css('.variables'));
        return this;
    }

    focusVariable(variable) {
        new InlineEditor(`#release-properties div[inline-text-editor][name='${variable}']`).focus();
        return this;
    }

    setPasswordVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties div[inline-password-editor][name='${variable}'] `);
        editor.set(value);
        return this;
    }

    setVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties div[inline-text-editor][name='${variable}']`);
        editor.set(value);
        return this;
    }

    togglePublicLink() {
        element(By.css("#releaseForm-calendarPublished")).click();
        return this;
    }

    getAttachmentsList() {
        return new AttachmentsList("#release-properties .attachments-list");
    }

    checkAbortOnFailure() {
        element(By.css("#release-form-abort-on-failure")).click();
        return this;
    }

    checkAllowPasswordsInAllFields() {
        element(By.css("#release-form-allow-passwords-in-all-fields")).click();
        return this;
    }

    checkDisableNotifications() {
        element(By.css("#release-form-disable-notifications")).click();
        return this;
    }

    reload() {
        Browser.softReload();
        return this;
    }

    expectVariableDisplayed(variable, present) {
        cy.get(`#release-properties .form-group:contains('${variable}')`).should('be.visible');
        return this;
    }

    expectVariablesCountToBe(variablesCount) {
        cy.get("div[inline-text-editor]").should('have.length', variablesCount);
        return this;
    }

    expectContainingVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties .form-group:contains('${variable}') div[inline-text-editor]`);
        expect(editor.value()).toBe(value);
        return this;
    }
}

export class TemplatePropertiesPage extends PropertiesPage {

    setName(name) {
        cy.get('#release-form-title').type(name);
        return this;
    }

    setDescription(description) {
        new TextareaInlineEditor(".release-description").set(description);
        return this;
    }

    getAttachmentsList() {
        return new AttachmentsList("#template-properties .attachments-list");
    }

    save() {
        super.save();
        cy.get('#release').should('be.visible');
    }

    addTag(tagName) {
        return new TagEditor('#tags').addTag(tagName);
    }

    expectTemplateTaggedWith(tagName) {
         new TagEditor('#tags').expectTaggedWith(tagName);
    }

}
