import {NotificationSettingsModal} from './notification-settings-modal';

export class NotificationSettings {

    getTasksTableElement() {
        return cy.get('.tasks-table table');
    }

    getTasksTableRows() {
        return this.getTasksTableElement().find('tbody').find('tr');
    }

    getTasksRoleNameSearchInput() {
        return this.getTasksTableElement().find('.with-search > input[type=text]').last();
    }

    getTasksEventIdSearchInput() {
        return this.getTasksTableElement().find('.with-search > input[type=text]').first();
    }

    getReleasesTableElement() {
        return cy.get('.releases-table table');
    }

    getEditMessageElements() {
        return cy.get("a.action.link:contains('Edit Message')");
    }

    getEventElement(eventName) {
        return cy.get(`tbody > tr > td:contains('${eventName}')`);
    }

    getEventRowElement(eventName) {
        return this.getEventElement(eventName).closest('tr');
    }

    getRoleElementFromEvent(eventName, roleName) {
        return this.getEventRowElement(eventName).find(`.role-cell .tag.role span:contains('${roleName}')`);
    }

    getRoleTagElementFromEvent(eventName, roleName) {
        return this.getRoleElementFromEvent(eventName, roleName).closest('.tag.role');
    }

    getCloseTagElements() {
        return cy.get('.tag.role a.tag-close');
    }

    getSuggestionTag() {
        return cy.get('.xlr-tags-suggestions .tag-label');
    }

    getSuggestedRoleElement(roleName) {
        return cy.get(`.xlr-tags-suggestions .tag-label:contains(${roleName})`);
    }

    findRoleIconElementFromEvent(eventName, roleName) {
        return this.getRoleTagElementFromEvent(eventName, roleName).find('span.xl-icon.tag-icon');
    }

    findCloseTagOnElement(element) {
        return element.find('a.tag-close');
    }

    findAddTagInputElementOnRow(eventRowElement) {
        return eventRowElement.find('input[type=text].tag-input');
    }

    findEditMessageLinkElementOnRow(eventRowElement) {
        return eventRowElement.find("a.action.link:contains('Edit Message')");
    }

    expectTablesToBeInReadOnlyMode(shouldBeReadOnly = true) {
        const existExpectancy = shouldBeReadOnly ? 'to.not.exist' : 'to.exist';
        this.getEditMessageElements().should(existExpectancy);
        this.getCloseTagElements().should(existExpectancy);
        return this;
    }

    expectRoleTagToBePresentOnEvent(eventName, roleName, shouldBePresent = true) {
        const existExpectancy = shouldBePresent ? 'exist' : 'not.exist';
        this.getRoleElementFromEvent(eventName, roleName).should(existExpectancy);
        return this;
    }

    expectRoleTagToHaveIcon(eventName, roleName, shouldHaveIcon = true) {
        const iconExistExpectancy = shouldHaveIcon ? 'exist' : 'not.exist';
        this.findRoleIconElementFromEvent(eventName, roleName).should(iconExistExpectancy);
        return this;
    }

    expectSuggestionTagToHaveText(expectedText) {
        this.getSuggestionTag().should('have.text', expectedText);
        return this;
    }

    expectSuggestedRoleToBeVisible(roleName, shouldBeVisible = true) {
        const existExpectancy = shouldBeVisible ? 'be.visible' : 'not.exist';
        this.getSuggestedRoleElement(roleName).should(existExpectancy);
        return this;
    }

    expectTaskEventTableToHaveNumberOfRows(numberOfRows) {
        this.getTasksTableRows().should('have.length', numberOfRows);
        return this;
    }

    selectSuggestedRole(roleName) {
        this.getSuggestedRoleElement(roleName).click();
        return this;
    }

    removeRoleTagFromEvent(eventName, roleName) {
        const roleTagElement = this.getRoleTagElementFromEvent(eventName, roleName);
        this.findCloseTagOnElement(roleTagElement).click();
        return this;
    }

    typeRoleTagNameInEventInput(eventName, roleName) {
        const eventRowElement = this.getEventRowElement(eventName);
        eventRowElement.scrollIntoView();
        this.findAddTagInputElementOnRow(eventRowElement).type(roleName);
        return this;
    }

    clearRoleTagNameInEventInput(eventName) {
        const eventRowElement = this.getEventRowElement(eventName);
        this.findAddTagInputElementOnRow(eventRowElement).clear();
        return this;
    }

    filterTaskTableByEventId(filterText) {
        this.getTasksEventIdSearchInput().type(filterText);
        return this;
    }

    openEditMessageFromEvent(eventName) {
        const eventRow = this.getEventRowElement(eventName);
        this.findEditMessageLinkElementOnRow(eventRow).click();
        return new NotificationSettingsModal(eventName);
    }

    openModalAndExpectData(eventName, {priority, subject, body}) {
        return this.openEditMessageFromEvent(eventName)
            .hasPriority(priority)
            .hasSubject(subject)
            .hasBody(body);
    }

    changeEmailDataWithAssertion(eventName, {priority, subject, body}) {
        return this.openEditMessageFromEvent(eventName)
            .expectBodyTextareaControlsToExist(false)
            .setPriority(priority)
            .expectModalCancelButtonToBeEnabled()
            .hasPriority(priority)
            .expectModalCancelButtonToBeEnabled()
            .setSubject(subject)
            .expectModalCancelButtonToBeEnabled()
            .hasSubject(subject)
            .setBody(body)
            .expectModalCancelButtonToBeEnabled()
            .hasBody(body)
            .expectModalControlButtonsToBeEnabled();
    }

    changeEmailDataSaveChangesAndAssert(eventName, emailData) {
        const notificationSettingsModal = this.changeEmailDataWithAssertion(eventName, emailData);
        notificationSettingsModal
            .save()
            .expectNotificationSettingsModalToBeVisible(false);
        return this;
    }

    changeEmailDataCancelChangesAndAssert(eventName, emailData) {
        const notificationSettingsModal = this.changeEmailDataWithAssertion(eventName, emailData);
        notificationSettingsModal
            .cancel()
            .expectLeaveConfirmationModalToBeVisible()
            .confirmLeave();
        return this;
    }

    assertTypedRoleInSuggestionsList(eventName, roleName, shouldBeVisible = true) {
        this.typeRoleTagNameInEventInput(eventName, roleName)
            .expectSuggestedRoleToBeVisible(roleName, shouldBeVisible)
            .clearRoleTagNameInEventInput(eventName);
        return this;
    }

    assertTypedRolesInSuggestionsList(eventName, roles, shouldBeVisible = true) {
        roles.forEach((role) => this.assertTypedRoleInSuggestionsList(eventName, role, shouldBeVisible));
        return this;
    }

    assertRolesPresenceOnEvent(eventName, roles) {
        roles.forEach((role) => this.expectRoleTagToBePresentOnEvent(eventName, role));
        return this;
    }


}
