export default class MainMenuPage {
    expectMenu(title) {
        cy.get(`.menu-level-0 .menu-element:contains('${title}')`).should('have.length',1);
        return this;
    }

    clickMenu(title) {
        cy.get(`.menu-level-0 .menu-element:contains('${title}')`).click();
        return this;
    }

    expectSubMenu(title) {
        cy.get(`.nav-in-header li:contains('${title}')`).should('have.length',1);
        return this;
    }

    selectSubMenu(title) {
        cy.get(`.nav-in-header li:contains('${title}')`).click();
        return this;
    }

    configureSystemMessage() {
        cy.server();
        cy.route('**/settings/system-message*').as('getMessage');
        cy.get('.current-user:visible .actions.settings').click();
        cy.get('#actions-container li').contains('Configure system message').click();
        cy.wait('@getMessage');
        cy.wait(500);
        cy.get('#enabled').should('be.visible');
        cy.get('button.save.primary').should('be.visible');
        return this;

    }

    logout() {
        cy.get('.current-user:visible .actions.settings').click();
        cy.get('#actions-container .logout').click();
        cy.get('#login').should('be.visible');
        return this;
    }

    expectUserNotVisible() {
        cy.get('.current-user:visible').should('not.be.visible');
        return this;
    }

    expectUserVisible() {
        cy.get('.current-user:visible').should('be.visible');
        return this;
    }
}
