import {TaskDetails} from './task-details';
import Dependency from '../dependency';
import {XlrDependencyWithVariables} from '../xlr-input-with-variables';
import _ from 'lodash';

export class GateDetails extends TaskDetails {

    countDependenciesToBe(size) {
        cy.get('#resizable-modal .dependency').should('have.length',size);
        return this;
    }

    addDependency() {
        cy.get('#resizable-modal .add-dependency').click();
        return new XlrDependencyWithVariables("#resizable-modal .dependency:last");
    }

    deleteDependency(title) {
        cy.get(`#resizable-modal .dependency:contains('${title}') .link.context-menu-button`).click();
        cy.get(`#resizable-modal .dependency:contains('${title}') .popover .dropdown-menu #removeDependency`).click();
        return this;
    }

    getDependency(index) {
        const dependency = new Dependency(`#resizable-modal .dependency:nth('${index}')`);
        return dependency;
    }

    addNewCondition() {
        cy.get(`#resizable-modal .link:contains('Add condition')`).click();
        return this;
    }

    removeCondition(title) {
        cy.get(`#resizable-modal .condition:contains('${title}') .remove-condition`).click();
        return this;
    }

    checkCondition(title) {
        cy.get(`#resizable-modal .condition:contains('${title}') input:checkbox`).click();
        return this;
    }

    expectDependency(title, visible = true) {
        cy.get(`.dependency-objects:contains('${title}')`).should('have.length', visible ? 1 : 0);
        return this;
    }

    expectConditionsDisplayed(conditions) {
        _.forOwn(conditions, (value, title) => {
            cy.get(`#resizable-modal .condition:contains('${title}')`).should(value ? 'exist' : 'not.exist');
        });
        return this;
    }

    expectConditionsChecked(conditions) {
        _.forOwn(conditions, (value, title) => {
            cy.get(`#resizable-modal .condition:contains('${title}') input:checkbox:checked`).should('be', value);
        });
        return this;
    }
}