import DateTimePicker from '../date-time-picker';
import {TaskDetails} from './task-details';
import {TextareaInlineEditor, VariableListInlineEditor} from "../../pages/inline-editor";
import {XlDipListOfCi} from "../xl-components";
import _ from 'lodash';
import {VariablesEditor} from "../variables-editor";

export class UserInputDetails extends TaskDetails {

    complete() {
        cy.get('button').contains('Complete').click();
        cy.get('button').contains('OK').click();
        return this;
    }

    startTask() {
        cy.get('button').contains('Start task').click();
        return this;
    }

    setDateVariable(inputId, value) {
        cy.server();
        cy.route('PUT', '**/api/v1/releases/**').as('updateVariable');
        new DateTimePicker(`#${inputId} .date-editor`).setDate(value);
        cy.wait('@updateVariable');
        return this;
    }

    expectUserInputVariableValueToBe(value) {
        cy.get('.form-group .display').should('contain', value);
        return this;
    }

    expectCompletedUserInputVariableValueToBe(value) {
        cy.get('.form-group .read-only').should('contain', value);
        return this;
    }

    expectVariablesDisplayedUnderDropdown() {
        cy.get('.button:contains("Edit variable list")').click();
        cy.get('.xl-components-input').click();
        return this;
    }

    expectVariablesDisplayed(variables) {
        Object.entries(variables).forEach(([name, value]) => {
            cy.get(`.variable-editor:contains('${name}')`).should(`${value ? '' : 'not.'}visible`);
        });
        return this;
    }

    expectDesignModeEnabled(enabled) {
        if (enabled) {
            cy.get("button:contains('Edit variable list')").should('be.visible');
        } else {
            cy.get("button:contains('Edit variable list')").should('not.be.visible');
        }
        return this;
    }

    expectTaskVariablesFormDisplayed(form) {
        cy.get(`form[name=${form}]`, {timeout: 6000}).should('be.visible');
        return this;
    }

    switchToDesignMode() {
        cy.get("button:contains('Edit variable list')").click();
        return this;
    }

    getVariablesPicker() {
        return new XlDipListOfCi("form[name=userInputDesignForm] div[xl-dip-list-of-ci]");
    }

    saveVariablesList() {
        cy.get("form[name=userInputDesignForm] .button.save").click();
        return this;
    }

    setVariableValue(key, value, multiline = false, form = 'userInputForm') {
        this.expectTaskVariablesFormDisplayed(form);
        if (multiline) {
            new TextareaInlineEditor(`form[name=userInputForm] div[inline-textarea-editor][name='${key}']`)
            new TextareaInlineEditor(`form[name=${form}] div[inline-textarea-editor][name='${key}']`)
                .set(value);
        } else {
            new VariableListInlineEditor(`form[name=userInputForm] div[inline-text-editor][name='${key}']`)
            new VariableListInlineEditor(`form[name=${form}] div[inline-text-editor][name='${key}']`)
                .set(value);
        }
        return this;
    }

}
