import {XlWidgetAutocomplete, XlDipCheckbox} from './xl-components';
import {DipListString} from './list-string';
import {DipMapStringString} from './map-string-string';
import {DipSetString} from './set-string';
import {InlineEditor} from '../pages/inline-editor';
import DependencyEditor from './dependency-editor';

class XlrInputWithVariables {
    constructor(path, inputEditorGetter) {
        cy.get(path).scrollIntoView();
        this.path = path;
        this.inputEditorGetter = inputEditorGetter;
        this.variablePicker = new XlWidgetAutocomplete(this.path);
        this.modeToggle = `${this.path} .variable-toggle .button`;
    }

    editor() {
        return this.inputEditorGetter();
    }

    variableSelector() {
        return this.variablePicker;
    }

    toggleMode() {
        // cy.get(this.modeToggle).scrollIntoView().should('be.visible');
        cy.get(this.modeToggle).click({force: true});
        return this;
    }

    expectEditMode() {
        cy.get(`${this.path} .editor`).should('have.length', 1);
        return this;
    }

    expectVariableMode() {
        cy.get(`${this.path} .variable-dropdown`).should('have.length', 1);
        return this;
    }

    expectToggleVisible(visible = true) {
        cy.get(this.modeToggle).should(`${visible ? '' : 'not.'}be.visible`);
        return this;
    }
}


export class XlrInlinePasswordWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new InlineEditor(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrListStringWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new DipListString(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrSetStringWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new DipSetString(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrMapStringStringWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new DipMapStringString(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrIntegerWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new XlDipInteger(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrBooleanWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new XlDipCheckbox(`${path} .field`);
        });
        this.path = path;
    }
}

export class XlrDependencyWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new DependencyEditor(`${path} .editor`);
        });
        this.path = path;
    }

    save() {
        cy.get(`${this.path} .button.save`).click();
        return this;
    }

    cancel() {
        cy.get(`${this.path} .button.cancel`).click();
        return this;
    }

    selectManualMode() {
        this.selectMode("Release, phase, or task");
        return this;
    }

    selectVariableMode() {
        this.selectMode("Variable");
        return this;
    }

    selectMode(mode) {
        cy.get(`${this.path} button:contains('${mode}')`).click();
        return this;
    }
}

class XlrDateWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new DateTimePicker(`${path} .date-editor:first`);
        });
        this.path = path;
    }
}

export class XlrDropdownWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new XlWidgetAutocomplete(`${path}`);
        });
        this.path = path;
    }
}

export class XlrInlineTextWithVariables extends XlrInputWithVariables {
    constructor(path) {
        super(path, function () {
            return new InlineEditor(`${path} .field`);
        });
        this.path = path;
    }
}
