/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

import org.jline.style.MemoryStyleSource;
import org.jline.style.StyleExpression;
import org.jline.style.StyleResolver;
import org.jline.style.StyleSource;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.shell.style.Theme;
import org.springframework.shell.style.ThemeRegistry;

public class ThemeResolver {
    private StyleSource styleSource = new MemoryStyleSource();
    private StyleResolver styleResolver = new StyleResolver(this.styleSource, "default");
    private StyleExpression styleExpression = new StyleExpression(this.styleResolver);
    private final Theme theme;

    public ThemeResolver(ThemeRegistry themeRegistry, String themeName) {
        this.theme = themeRegistry.get(themeName);
    }

    public AttributedString evaluateExpression(String expression) {
        return this.styleExpression.evaluate(expression);
    }

    public String resolveStyleTag(String tag) {
        return this.theme.getSettings().styles().resolveTag(tag);
    }

    public String resolveFigureTag(String tag) {
        return this.theme.getSettings().figures().resolveTag(tag);
    }

    public AttributedStyle resolveStyle(String spec) {
        return this.styleResolver.resolve(spec);
    }
}

