/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.style;

public abstract class StyleSettings {
    public static final String TAG_TITLE = "style-title";
    public static final String TAG_VALUE = "style-value";
    public static final String TAG_LIST_KEY = "style-list-key";
    public static final String TAG_LIST_VALUE = "style-list-value";
    public static final String TAG_LEVEL_INFO = "style-level-info";
    public static final String TAG_LEVEL_WARN = "style-level-warn";
    public static final String TAG_LEVEL_ERROR = "style-level-error";
    public static final String TAG_ITEM_ENABLED = "style-item-enabled";
    public static final String TAG_ITEM_DISABLED = "style-item-disabled";
    public static final String TAG_ITEM_SELECTED = "style-item-selected";
    public static final String TAG_ITEM_UNSELECTED = "style-item-unselected";
    public static final String TAG_ITEM_SELECTOR = "style-item-selector";
    public static final String TAG_HIGHLIGHT = "style-highlight";

    public String title() {
        return "bold";
    }

    public String value() {
        return "fg:blue";
    }

    public String listKey() {
        return "default";
    }

    public String listValue() {
        return "bold,fg:green";
    }

    public String listLevelInfo() {
        return "fg:green";
    }

    public String listLevelWarn() {
        return "fg:yellow";
    }

    public String listLevelError() {
        return "fg:red";
    }

    public String itemEnabled() {
        return "bold";
    }

    public String itemDisabled() {
        return "faint";
    }

    public String itemSelected() {
        return "fg:green";
    }

    public String itemUnselected() {
        return "bold";
    }

    public String itemSelector() {
        return "bold,fg:bright-cyan";
    }

    public String highlight() {
        return "bold";
    }

    public String resolveTag(String tag) {
        switch (tag) {
            case "style-title": {
                return this.title();
            }
            case "style-value": {
                return this.value();
            }
            case "style-list-key": {
                return this.listKey();
            }
            case "style-list-value": {
                return this.listValue();
            }
            case "style-level-info": {
                return this.listLevelInfo();
            }
            case "style-level-warn": {
                return this.listLevelWarn();
            }
            case "style-level-error": {
                return this.listLevelError();
            }
            case "style-item-enabled": {
                return this.itemEnabled();
            }
            case "style-item-disabled": {
                return this.itemDisabled();
            }
            case "style-item-selected": {
                return this.itemSelected();
            }
            case "style-item-unselected": {
                return this.itemUnselected();
            }
            case "style-item-selector": {
                return this.itemSelector();
            }
            case "style-highlight": {
                return this.highlight();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown tag '%s'", tag));
    }

    public static StyleSettings defaults() {
        return new DefaultStyleSettings();
    }

    public static StyleSettings dump() {
        return new DumpStyleSettings();
    }

    public static String[] tags() {
        return new String[]{TAG_TITLE, TAG_VALUE, TAG_LIST_KEY, TAG_LIST_VALUE, TAG_LEVEL_INFO, TAG_LEVEL_WARN, TAG_LEVEL_ERROR, TAG_ITEM_ENABLED, TAG_ITEM_DISABLED, TAG_ITEM_SELECTED, TAG_ITEM_UNSELECTED, TAG_ITEM_SELECTOR, TAG_HIGHLIGHT};
    }

    private static class DumpStyleSettings
    extends StyleSettings {
        private DumpStyleSettings() {
        }

        @Override
        public String title() {
            return "default";
        }

        @Override
        public String value() {
            return "default";
        }

        @Override
        public String listKey() {
            return "default";
        }

        @Override
        public String listValue() {
            return "default";
        }

        @Override
        public String listLevelInfo() {
            return "default";
        }

        @Override
        public String listLevelWarn() {
            return "default";
        }

        @Override
        public String listLevelError() {
            return "default";
        }

        @Override
        public String itemEnabled() {
            return "default";
        }

        @Override
        public String itemDisabled() {
            return "default";
        }

        @Override
        public String itemSelected() {
            return "default";
        }

        @Override
        public String itemUnselected() {
            return "default";
        }

        @Override
        public String itemSelector() {
            return "default";
        }

        @Override
        public String highlight() {
            return "default";
        }
    }

    private static class DefaultStyleSettings
    extends StyleSettings {
        private DefaultStyleSettings() {
        }
    }
}

