/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.springframework.shell.Input;
import org.springframework.shell.InputProvider;
import org.springframework.shell.jline.ParsedLineInput;

public class FileInputProvider
implements InputProvider,
Closeable {
    private static final String BACKSLASH_AT_EOL_REGEX = "(.*)\\\\\\s*$";
    private final BufferedReader reader;
    private final Parser parser;

    public FileInputProvider(Reader reader, Parser parser) {
        this.reader = new BufferedReader(reader);
        this.parser = parser;
    }

    @Override
    public Input readInput() {
        String line;
        StringBuilder sb = new StringBuilder();
        boolean continued = false;
        try {
            while ((line = this.reader.readLine()) != null) {
                continued = line.matches(BACKSLASH_AT_EOL_REGEX);
                sb.append(line.replaceFirst(BACKSLASH_AT_EOL_REGEX, "$1 "));
                if (continued) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (line == null) {
            return null;
        }
        ParsedLine parsedLine = this.parser.parse(sb.toString(), sb.toString().length());
        return new ParsedLineInput(parsedLine);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

