/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.support;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.InfoCmp;
import org.springframework.shell.component.context.BaseComponentContext;
import org.springframework.shell.component.context.ComponentContext;
import org.springframework.shell.component.support.AbstractComponent;

public abstract class AbstractTextComponent<T, C extends TextComponentContext<T, C>>
extends AbstractComponent<C> {
    private final String name;

    public AbstractTextComponent(Terminal terminal) {
        this(terminal, null);
    }

    public AbstractTextComponent(Terminal terminal, String name) {
        this(terminal, name, null);
    }

    public AbstractTextComponent(Terminal terminal, String name, Function<C, List<AttributedString>> renderer) {
        super(terminal);
        this.name = name;
        this.setRenderer(renderer);
    }

    @Override
    protected void bindKeyMap(KeyMap<String> keyMap) {
        keyMap.bind((Object)"EXIT", (CharSequence)"\r");
        keyMap.bind((Object)"BACKSPACE", new CharSequence[]{KeyMap.del(), KeyMap.key((Terminal)this.getTerminal(), (InfoCmp.Capability)InfoCmp.Capability.key_backspace)});
        for (char i = ' '; i < '\u007f'; i = (char)(i + '\u0001')) {
            keyMap.bind((Object)"CHAR", (CharSequence)Character.toString(i));
        }
    }

    @Override
    protected C runInternal(C context) {
        if (this.hasTty()) {
            this.loop((ComponentContext<?>)context);
        }
        return context;
    }

    protected String getName() {
        return this.name;
    }

    public static class BaseTextComponentContext<T, C extends TextComponentContext<T, C>>
    extends BaseComponentContext<C>
    implements TextComponentContext<T, C> {
        private String name;
        private String input;
        private T resultValue;
        private String message;
        private TextComponentContext.MessageLevel messageLevel = TextComponentContext.MessageLevel.INFO;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public void setInput(String input) {
            this.input = input;
        }

        @Override
        public T getResultValue() {
            return this.resultValue;
        }

        @Override
        public void setResultValue(T resultValue) {
            this.resultValue = resultValue;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public void setMessage(String message, TextComponentContext.MessageLevel level) {
            this.setMessage(message);
            this.setMessageLevel(level);
        }

        @Override
        public TextComponentContext.MessageLevel getMessageLevel() {
            return this.messageLevel;
        }

        @Override
        public void setMessageLevel(TextComponentContext.MessageLevel messageLevel) {
            this.messageLevel = messageLevel;
        }

        @Override
        public Map<String, Object> toTemplateModel() {
            Map<String, Object> attributes = super.toTemplateModel();
            attributes.put("resultValue", this.getResultValue() != null ? this.getResultValue().toString() : null);
            attributes.put("name", this.getName());
            attributes.put("message", this.getMessage());
            attributes.put("messageLevel", (Object)this.getMessageLevel());
            attributes.put("hasMessageLevelInfo", this.getMessageLevel() == TextComponentContext.MessageLevel.INFO);
            attributes.put("hasMessageLevelWarn", this.getMessageLevel() == TextComponentContext.MessageLevel.WARN);
            attributes.put("hasMessageLevelError", this.getMessageLevel() == TextComponentContext.MessageLevel.ERROR);
            attributes.put("input", this.getInput());
            return attributes;
        }
    }

    public static interface TextComponentContext<T, C extends TextComponentContext<T, C>>
    extends ComponentContext<C> {
        public String getName();

        public void setName(String var1);

        public String getInput();

        public void setInput(String var1);

        public T getResultValue();

        public void setResultValue(T var1);

        public String getMessage();

        public void setMessage(String var1);

        public void setMessage(String var1, MessageLevel var2);

        public MessageLevel getMessageLevel();

        public void setMessageLevel(MessageLevel var1);

        public static enum MessageLevel {
            INFO,
            WARN,
            ERROR;

        }
    }
}

