/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.component.flow;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jline.utils.AttributedString;
import org.springframework.shell.component.SingleItemSelector;
import org.springframework.shell.component.flow.BaseInput;
import org.springframework.shell.component.flow.ComponentFlow;
import org.springframework.shell.component.flow.ResultMode;
import org.springframework.shell.component.flow.SingleItemSelectorSpec;
import org.springframework.shell.component.support.SelectorItem;

public abstract class BaseSingleItemSelector
extends BaseInput<SingleItemSelectorSpec>
implements SingleItemSelectorSpec {
    private String name;
    private String resultValue;
    private ResultMode resultMode;
    private Map<String, String> selectItems = new HashMap<String, String>();
    private String defaultSelect;
    private Comparator<SelectorItem<String>> comparator;
    private Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> renderer;
    private Integer maxItems;
    private List<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>> preHandlers = new ArrayList<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>>();
    private List<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>> postHandlers = new ArrayList<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>>();
    private boolean storeResult = true;
    private String templateLocation;
    private Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, String> next;

    public BaseSingleItemSelector(ComponentFlow.BaseBuilder builder, String id) {
        super(builder, id);
    }

    @Override
    public SingleItemSelectorSpec name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public SingleItemSelectorSpec resultValue(String resultValue) {
        this.resultValue = resultValue;
        return this;
    }

    @Override
    public SingleItemSelectorSpec resultMode(ResultMode resultMode) {
        this.resultMode = resultMode;
        return this;
    }

    @Override
    public SingleItemSelectorSpec selectItem(String name, String item) {
        this.selectItems.put(name, item);
        return this;
    }

    @Override
    public SingleItemSelectorSpec selectItems(Map<String, String> selectItems) {
        this.selectItems.putAll(selectItems);
        return this;
    }

    @Override
    public SingleItemSelectorSpec defaultSelect(String name) {
        this.defaultSelect = name;
        return this;
    }

    @Override
    public SingleItemSelectorSpec sort(Comparator<SelectorItem<String>> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public SingleItemSelectorSpec renderer(Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public SingleItemSelectorSpec template(String location) {
        this.templateLocation = location;
        return this;
    }

    @Override
    public SingleItemSelectorSpec max(int max) {
        this.maxItems = max;
        return this;
    }

    @Override
    public SingleItemSelectorSpec preHandler(Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>> handler) {
        this.preHandlers.add(handler);
        return null;
    }

    @Override
    public SingleItemSelectorSpec postHandler(Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>> handler) {
        this.postHandlers.add(handler);
        return this;
    }

    @Override
    public SingleItemSelectorSpec storeResult(boolean store) {
        this.storeResult = store;
        return this;
    }

    @Override
    public SingleItemSelectorSpec next(Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, String> next) {
        this.next = next;
        return this;
    }

    @Override
    public ComponentFlow.Builder and() {
        this.getBuilder().addSingleItemSelector(this);
        return this.getBuilder();
    }

    @Override
    public SingleItemSelectorSpec getThis() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getResultValue() {
        return this.resultValue;
    }

    public ResultMode getResultMode() {
        return this.resultMode;
    }

    public Map<String, String> getSelectItems() {
        return this.selectItems;
    }

    public String getDefaultSelect() {
        return this.defaultSelect;
    }

    public Comparator<SelectorItem<String>> getComparator() {
        return this.comparator;
    }

    public Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, List<AttributedString>> getRenderer() {
        return this.renderer;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public List<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>> getPreHandlers() {
        return this.preHandlers;
    }

    public List<Consumer<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>>> getPostHandlers() {
        return this.postHandlers;
    }

    public boolean isStoreResult() {
        return this.storeResult;
    }

    public Function<SingleItemSelector.SingleItemSelectorContext<String, SelectorItem<String>>, String> getNext() {
        return this.next;
    }
}

